/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.block.column.ColumnBuilderStatus;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.ColumnUtil;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class TimeColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(TimeColumnBuilder.class);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public TimeColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public ColumnBuilder writeInt(int value) {
        return this.writeLong(value);
    }

    @Override
    public ColumnBuilder writeLong(long value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(8);
        }
        return this;
    }

    @Override
    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Long) {
            this.writeLong((Long)value);
            return this;
        }
        throw new UnSupportedDataTypeException("LongColumn only support Long data type");
    }

    @Override
    public ColumnBuilder write(Column column, int index) {
        return this.writeLong(column.getLong(index));
    }

    @Override
    public ColumnBuilder appendNull() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public ColumnBuilder appendNull(int nullCount) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Column build() {
        return new TimeColumn(0, this.positionCount, this.values);
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new TimeColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public long getTime(int position) {
        this.checkReadablePosition(position);
        return this.values[position];
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOf(this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

