/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceForRegionScan;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IFileScanHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.utils.TimeFilterForDeviceTTL;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.TimeFilter;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public abstract class AbstractRegionScanForActiveDataUtil
implements Accountable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(List.class) + RamUsageEstimator.shallowSizeOfInstance(List.class) + RamUsageEstimator.shallowSizeOfInstance(TimeFilter.class);
    protected QueryDataSourceForRegionScan queryDataSource;
    protected final TimeFilterForDeviceTTL timeFilter;
    protected final List<AbstractChunkOffset> chunkToBeScanned = new ArrayList<AbstractChunkOffset>();
    protected final List<Statistics<? extends Serializable>> chunkStatistics = new ArrayList<Statistics<? extends Serializable>>();
    protected IFileScanHandle curFileScanHandle = null;
    protected Iterator<AbstractDeviceChunkMetaData> deviceChunkMetaDataIterator = null;
    protected Iterator<IChunkHandle> chunkHandleIterator = null;
    protected IChunkHandle currentChunkHandle = null;

    protected AbstractRegionScanForActiveDataUtil(Filter timeFilter, Map<IDeviceID, Long> ttlCache) {
        this.timeFilter = new TimeFilterForDeviceTTL(timeFilter, ttlCache);
    }

    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.queryDataSource = (QueryDataSourceForRegionScan)dataSource;
    }

    public abstract boolean isCurrentTsFileFinished();

    public abstract void processDeviceChunkMetadata(AbstractDeviceChunkMetaData var1) throws IllegalPathException;

    public abstract boolean isCurrentChunkHandleValid();

    public abstract void processActiveChunk(IDeviceID var1, String var2);

    public void finishCurrentFile() {
        this.curFileScanHandle = null;
        this.deviceChunkMetaDataIterator = null;
        this.chunkHandleIterator = null;
        this.currentChunkHandle = null;
    }

    public boolean hasMoreData() {
        return this.queryDataSource != null && this.queryDataSource.hasNext();
    }

    public boolean filterChunkMetaData() throws IOException, IllegalPathException {
        if (this.isCurrentTsFileFinished()) {
            return false;
        }
        if (this.deviceChunkMetaDataIterator == null) {
            this.deviceChunkMetaDataIterator = this.curFileScanHandle.getAllDeviceChunkMetaData();
        }
        if (this.deviceChunkMetaDataIterator.hasNext()) {
            AbstractDeviceChunkMetaData deviceChunkMetaData = this.deviceChunkMetaDataIterator.next();
            this.processDeviceChunkMetadata(deviceChunkMetaData);
            return this.deviceChunkMetaDataIterator.hasNext();
        }
        return false;
    }

    public boolean filterChunkData() throws IOException, IllegalPathException {
        long[] timeDataForPage;
        if (this.isCurrentTsFileFinished()) {
            return false;
        }
        if (this.chunkHandleIterator == null) {
            this.chunkHandleIterator = this.curFileScanHandle.getChunkHandles(this.chunkToBeScanned, this.chunkStatistics, this.getOrderedIndex());
            this.chunkToBeScanned.clear();
            this.chunkStatistics.clear();
        }
        while (this.currentChunkHandle == null || !this.currentChunkHandle.hasNextPage()) {
            if (!this.chunkHandleIterator.hasNext()) {
                this.chunkHandleIterator = null;
                return false;
            }
            this.currentChunkHandle = this.chunkHandleIterator.next();
            if (this.isCurrentChunkHandleValid()) continue;
            this.currentChunkHandle = null;
        }
        this.currentChunkHandle.nextPage();
        IDeviceID curDevice = this.currentChunkHandle.getDeviceID();
        String curMeasurement = this.currentChunkHandle.getMeasurement();
        long[] pageStatistics = this.currentChunkHandle.getPageStatisticsTime();
        if (!this.timeFilter.satisfyStartEndTime(pageStatistics[0], pageStatistics[1], curDevice)) {
            this.currentChunkHandle.skipCurrentPage();
            return true;
        }
        if (this.timeFilter.satisfy(pageStatistics[0], curDevice) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(curDevice, curMeasurement, pageStatistics[0]) || this.timeFilter.satisfy(pageStatistics[1], curDevice) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(curDevice, curMeasurement, pageStatistics[1])) {
            this.processActiveChunk(curDevice, curMeasurement);
            return true;
        }
        for (long time : timeDataForPage = this.currentChunkHandle.getDataTime()) {
            if (!this.timeFilter.satisfy(time, curDevice) || this.curFileScanHandle.isTimeSeriesTimeDeleted(curDevice, curMeasurement, time)) continue;
            this.processActiveChunk(curDevice, curMeasurement);
            return true;
        }
        return this.currentChunkHandle.hasNextPage() || this.chunkHandleIterator.hasNext();
    }

    private List<Integer> getOrderedIndex() {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.chunkToBeScanned.size(); ++i2) {
            indexList.add(i2);
        }
        indexList.sort(Comparator.comparingLong(i -> this.chunkToBeScanned.get((int)i).getOffSet()));
        return indexList;
    }

    public boolean isFinished() {
        return this.queryDataSource == null || !this.queryDataSource.hasNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE;
    }
}

