/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.AbstractTableDeviceQueryNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TableDeviceQueryScanNode
extends AbstractTableDeviceQueryNode {
    private final long limit;
    private final boolean needAligned;

    public TableDeviceQueryScanNode(PlanNodeId planNodeId, String database, String tableName, List<List<SchemaFilter>> tagDeterminedPredicateList, Expression tagFuzzyPredicate, List<ColumnHeader> columnHeaderList, TDataNodeLocation senderLocation, long limit, boolean needAligned) {
        super(planNodeId, database, tableName, tagDeterminedPredicateList, tagFuzzyPredicate, columnHeaderList, senderLocation);
        this.limit = limit;
        this.needAligned = needAligned;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isNeedAligned() {
        return this.needAligned;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableDeviceQueryScan(this, context);
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_DEVICE_QUERY_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new TableDeviceQueryScanNode(this.getPlanNodeId(), this.database, this.tableName, this.tagDeterminedPredicateList, this.tagFuzzyPredicate, this.columnHeaderList, this.senderLocation, this.limit, this.needAligned);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        super.serializeAttributes(byteBuffer);
        ReadWriteIOUtils.write((long)this.limit, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.needAligned, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        super.serializeAttributes(stream);
        ReadWriteIOUtils.write((long)this.limit, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.needAligned, (OutputStream)stream);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        return AbstractTableDeviceQueryNode.deserialize(buffer, true);
    }

    public String toString() {
        return "TableDeviceQueryScanNode" + this.toStringMessage();
    }
}

