/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class CreateFunction
extends Statement {
    private final String udfName;
    private final String className;
    @Nullable
    private final String uriString;

    public CreateFunction(NodeLocation location, String udfName, String className) {
        super(Objects.requireNonNull(location, "location is null"));
        this.udfName = Objects.requireNonNull(udfName, "udfName is null");
        this.className = Objects.requireNonNull(className, "className is null");
        this.uriString = null;
    }

    public CreateFunction(NodeLocation location, String udfName, String className, String uriString) {
        super(Objects.requireNonNull(location, "location is null"));
        this.udfName = Objects.requireNonNull(udfName, "udfName is null");
        this.className = Objects.requireNonNull(className, "className is null");
        this.uriString = Objects.requireNonNull(uriString, "uriString is null");
    }

    public String getUdfName() {
        return this.udfName;
    }

    public String getClassName() {
        return this.className;
    }

    public Optional<String> getUriString() {
        return Optional.ofNullable(this.uriString);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFunction that = (CreateFunction)o;
        return Objects.equals(this.udfName, that.udfName) && Objects.equals(this.className, that.className) && Objects.equals(this.uriString, that.uriString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.udfName, this.className, this.uriString);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("udfName", (Object)this.udfName).add("className", (Object)this.className).add("uriString", (Object)this.uriString).toString();
    }
}

