/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common;

import java.util.Objects;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.Path;

public class FullPath
extends Path {
    public FullPath(IDeviceID device, String measurement) {
        this.device = device;
        this.measurement = measurement;
    }

    @Override
    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.device.toString() + "." + this.measurement;
        }
        return this.fullPath;
    }

    @Override
    public int hashCode() {
        return this.device.hashCode() + this.measurement.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        return Objects.equals(this.device, ((Path)obj).getIDeviceID()) && Objects.equals(this.measurement, ((Path)obj).getMeasurement());
    }

    @Override
    public int compareTo(Path path) {
        int deviceCompare = this.device.compareTo(path.getIDeviceID());
        if (deviceCompare != 0) {
            return deviceCompare;
        }
        return this.measurement.compareTo(path.getMeasurement());
    }
}

