/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicFileOutputStream
extends FilterOutputStream {
    static final Logger LOG = LoggerFactory.getLogger(AtomicFileOutputStream.class);
    public static final String TMP_EXTENSION = ".tmp";
    private final File outFile;
    private final File tmpFile;
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public static File getTemporaryFile(File outFile) {
        return new File(outFile.getParentFile(), outFile.getName() + TMP_EXTENSION);
    }

    public AtomicFileOutputStream(File outFile) throws IOException {
        this(outFile, AtomicFileOutputStream.getTemporaryFile(outFile));
    }

    public AtomicFileOutputStream(File outFile, File tmpFile) throws IOException {
        super(FileUtils.newOutputStreamForceAtClose(tmpFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));
        this.outFile = outFile.getAbsoluteFile();
        this.tmpFile = tmpFile.getAbsoluteFile();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        try {
            super.close();
            FileUtils.move(this.tmpFile, this.outFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            try {
                FileUtils.deleteIfExists(this.tmpFile);
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
    }

    public void abort() {
        if (this.isClosed.get()) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException ioe) {
            LOG.warn("Unable to abort file " + this.tmpFile, (Throwable)ioe);
        }
        finally {
            if (!this.tmpFile.delete()) {
                LOG.warn("Unable to delete tmp file during abort " + this.tmpFile);
            }
        }
    }
}

