/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.tsfile.read.common.block.TsBlock;

public class DescBooleanTypeJoinKeyComparator
implements JoinKeyComparator {
    private static final DescBooleanTypeJoinKeyComparator INSTANCE = new DescBooleanTypeJoinKeyComparator();

    private DescBooleanTypeJoinKeyComparator() {
    }

    public static DescBooleanTypeJoinKeyComparator getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<Boolean> lessThan(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(this.transformBooleanToInt(left.getColumn(leftColumnIndex).getBoolean(leftRowIndex)) > this.transformBooleanToInt(right.getColumn(rightColumnIndex).getBoolean(rightRowIndex)));
    }

    @Override
    public Optional<Boolean> equalsTo(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(left.getColumn(leftColumnIndex).getBoolean(leftRowIndex) == right.getColumn(rightColumnIndex).getBoolean(rightRowIndex));
    }

    @Override
    public Optional<Boolean> lessThanOrEqual(TsBlock left, int leftColumnIndex, int leftRowIndex, TsBlock right, int rightColumnIndex, int rightRowIndex) {
        if (left.getColumn(leftColumnIndex).isNull(leftRowIndex) || right.getColumn(rightColumnIndex).isNull(rightRowIndex)) {
            return Optional.empty();
        }
        return Optional.of(this.transformBooleanToInt(left.getColumn(leftColumnIndex).getBoolean(leftRowIndex)) >= this.transformBooleanToInt(right.getColumn(rightColumnIndex).getBoolean(rightRowIndex)));
    }

    private int transformBooleanToInt(boolean value) {
        return value ? 1 : 0;
    }
}

