/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;

public class AllColumns
extends SelectItem {
    private final List<Identifier> aliases;
    @Nullable
    private final Expression target;

    public AllColumns() {
        super(null);
        this.target = null;
        this.aliases = ImmutableList.of();
    }

    public AllColumns(Expression target) {
        super(null);
        this.target = Objects.requireNonNull(target, "target is null");
        this.aliases = ImmutableList.of();
    }

    public AllColumns(Expression target, List<Identifier> aliases) {
        super(null);
        this.target = Objects.requireNonNull(target, "target is null");
        this.aliases = ImmutableList.copyOf((Collection)Objects.requireNonNull(aliases, "aliases is null"));
    }

    public AllColumns(NodeLocation location, Expression target, List<Identifier> aliases) {
        super(Objects.requireNonNull(location, "location is null"));
        this.target = Objects.requireNonNull(target, "target is null");
        this.aliases = ImmutableList.copyOf((Collection)Objects.requireNonNull(aliases, "aliases is null"));
    }

    public AllColumns(NodeLocation location, List<Identifier> aliases) {
        super(Objects.requireNonNull(location, "location is null"));
        this.target = null;
        this.aliases = ImmutableList.copyOf((Collection)Objects.requireNonNull(aliases, "aliases is null"));
    }

    public List<Identifier> getAliases() {
        return this.aliases;
    }

    public Optional<Expression> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAllColumns(this, context);
    }

    public List<Node> getChildren() {
        return this.target == null ? ImmutableList.of() : ImmutableList.of((Object)this.target);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllColumns other = (AllColumns)o;
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.target, other.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aliases, this.target);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.target != null) {
            builder.append(this.target).append(".");
        }
        builder.append("*");
        if (!this.aliases.isEmpty()) {
            builder.append(" (");
            Joiner.on((String)", ").appendTo(builder, this.aliases);
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!AllColumns.sameClass(this, other)) {
            return false;
        }
        return this.aliases.equals(((AllColumns)other).aliases);
    }
}

