/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.ConcatColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class Concat2ColumnTransformer
extends BinaryColumnTransformer {
    public Concat2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void checkType() {
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder columnBuilder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            this.transform(leftColumn, rightColumn, columnBuilder, i);
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (selection[i]) {
                this.transform(leftColumn, rightColumn, builder, i);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int i) {
        if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
            builder.writeBinary(new Binary(ConcatColumnTransformer.concat(leftColumn.getBinary(i).getValues(), rightColumn.getBinary(i).getValues())));
        } else if (!leftColumn.isNull(i)) {
            builder.writeBinary(leftColumn.getBinary(i));
        } else if (!rightColumn.isNull(i)) {
            builder.writeBinary(rightColumn.getBinary(i));
        } else {
            builder.appendNull();
        }
    }
}

