/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SubscriptionDiagnosticsDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=874");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=875");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=876");
    private final NodeId sessionId;
    private final UInteger subscriptionId;
    private final UByte priority;
    private final Double publishingInterval;
    private final UInteger maxKeepAliveCount;
    private final UInteger maxLifetimeCount;
    private final UInteger maxNotificationsPerPublish;
    private final Boolean publishingEnabled;
    private final UInteger modifyCount;
    private final UInteger enableCount;
    private final UInteger disableCount;
    private final UInteger republishRequestCount;
    private final UInteger republishMessageRequestCount;
    private final UInteger republishMessageCount;
    private final UInteger transferRequestCount;
    private final UInteger transferredToAltClientCount;
    private final UInteger transferredToSameClientCount;
    private final UInteger publishRequestCount;
    private final UInteger dataChangeNotificationsCount;
    private final UInteger eventNotificationsCount;
    private final UInteger notificationsCount;
    private final UInteger latePublishRequestCount;
    private final UInteger currentKeepAliveCount;
    private final UInteger currentLifetimeCount;
    private final UInteger unacknowledgedMessageCount;
    private final UInteger discardedMessageCount;
    private final UInteger monitoredItemCount;
    private final UInteger disabledMonitoredItemCount;
    private final UInteger monitoringQueueOverflowCount;
    private final UInteger nextSequenceNumber;
    private final UInteger eventQueueOverflowCount;

    public SubscriptionDiagnosticsDataType(NodeId sessionId, UInteger subscriptionId, UByte priority, Double publishingInterval, UInteger maxKeepAliveCount, UInteger maxLifetimeCount, UInteger maxNotificationsPerPublish, Boolean publishingEnabled, UInteger modifyCount, UInteger enableCount, UInteger disableCount, UInteger republishRequestCount, UInteger republishMessageRequestCount, UInteger republishMessageCount, UInteger transferRequestCount, UInteger transferredToAltClientCount, UInteger transferredToSameClientCount, UInteger publishRequestCount, UInteger dataChangeNotificationsCount, UInteger eventNotificationsCount, UInteger notificationsCount, UInteger latePublishRequestCount, UInteger currentKeepAliveCount, UInteger currentLifetimeCount, UInteger unacknowledgedMessageCount, UInteger discardedMessageCount, UInteger monitoredItemCount, UInteger disabledMonitoredItemCount, UInteger monitoringQueueOverflowCount, UInteger nextSequenceNumber, UInteger eventQueueOverflowCount) {
        this.sessionId = sessionId;
        this.subscriptionId = subscriptionId;
        this.priority = priority;
        this.publishingInterval = publishingInterval;
        this.maxKeepAliveCount = maxKeepAliveCount;
        this.maxLifetimeCount = maxLifetimeCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.publishingEnabled = publishingEnabled;
        this.modifyCount = modifyCount;
        this.enableCount = enableCount;
        this.disableCount = disableCount;
        this.republishRequestCount = republishRequestCount;
        this.republishMessageRequestCount = republishMessageRequestCount;
        this.republishMessageCount = republishMessageCount;
        this.transferRequestCount = transferRequestCount;
        this.transferredToAltClientCount = transferredToAltClientCount;
        this.transferredToSameClientCount = transferredToSameClientCount;
        this.publishRequestCount = publishRequestCount;
        this.dataChangeNotificationsCount = dataChangeNotificationsCount;
        this.eventNotificationsCount = eventNotificationsCount;
        this.notificationsCount = notificationsCount;
        this.latePublishRequestCount = latePublishRequestCount;
        this.currentKeepAliveCount = currentKeepAliveCount;
        this.currentLifetimeCount = currentLifetimeCount;
        this.unacknowledgedMessageCount = unacknowledgedMessageCount;
        this.discardedMessageCount = discardedMessageCount;
        this.monitoredItemCount = monitoredItemCount;
        this.disabledMonitoredItemCount = disabledMonitoredItemCount;
        this.monitoringQueueOverflowCount = monitoringQueueOverflowCount;
        this.nextSequenceNumber = nextSequenceNumber;
        this.eventQueueOverflowCount = eventQueueOverflowCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UByte getPriority() {
        return this.priority;
    }

    public Double getPublishingInterval() {
        return this.publishingInterval;
    }

    public UInteger getMaxKeepAliveCount() {
        return this.maxKeepAliveCount;
    }

    public UInteger getMaxLifetimeCount() {
        return this.maxLifetimeCount;
    }

    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public Boolean getPublishingEnabled() {
        return this.publishingEnabled;
    }

    public UInteger getModifyCount() {
        return this.modifyCount;
    }

    public UInteger getEnableCount() {
        return this.enableCount;
    }

    public UInteger getDisableCount() {
        return this.disableCount;
    }

    public UInteger getRepublishRequestCount() {
        return this.republishRequestCount;
    }

    public UInteger getRepublishMessageRequestCount() {
        return this.republishMessageRequestCount;
    }

    public UInteger getRepublishMessageCount() {
        return this.republishMessageCount;
    }

    public UInteger getTransferRequestCount() {
        return this.transferRequestCount;
    }

    public UInteger getTransferredToAltClientCount() {
        return this.transferredToAltClientCount;
    }

    public UInteger getTransferredToSameClientCount() {
        return this.transferredToSameClientCount;
    }

    public UInteger getPublishRequestCount() {
        return this.publishRequestCount;
    }

    public UInteger getDataChangeNotificationsCount() {
        return this.dataChangeNotificationsCount;
    }

    public UInteger getEventNotificationsCount() {
        return this.eventNotificationsCount;
    }

    public UInteger getNotificationsCount() {
        return this.notificationsCount;
    }

    public UInteger getLatePublishRequestCount() {
        return this.latePublishRequestCount;
    }

    public UInteger getCurrentKeepAliveCount() {
        return this.currentKeepAliveCount;
    }

    public UInteger getCurrentLifetimeCount() {
        return this.currentLifetimeCount;
    }

    public UInteger getUnacknowledgedMessageCount() {
        return this.unacknowledgedMessageCount;
    }

    public UInteger getDiscardedMessageCount() {
        return this.discardedMessageCount;
    }

    public UInteger getMonitoredItemCount() {
        return this.monitoredItemCount;
    }

    public UInteger getDisabledMonitoredItemCount() {
        return this.disabledMonitoredItemCount;
    }

    public UInteger getMonitoringQueueOverflowCount() {
        return this.monitoringQueueOverflowCount;
    }

    public UInteger getNextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    public UInteger getEventQueueOverflowCount() {
        return this.eventQueueOverflowCount;
    }

    protected SubscriptionDiagnosticsDataType(SubscriptionDiagnosticsDataTypeBuilder<?, ?> b) {
        super(b);
        this.sessionId = ((SubscriptionDiagnosticsDataTypeBuilder)b).sessionId;
        this.subscriptionId = ((SubscriptionDiagnosticsDataTypeBuilder)b).subscriptionId;
        this.priority = ((SubscriptionDiagnosticsDataTypeBuilder)b).priority;
        this.publishingInterval = ((SubscriptionDiagnosticsDataTypeBuilder)b).publishingInterval;
        this.maxKeepAliveCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).maxKeepAliveCount;
        this.maxLifetimeCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).maxLifetimeCount;
        this.maxNotificationsPerPublish = ((SubscriptionDiagnosticsDataTypeBuilder)b).maxNotificationsPerPublish;
        this.publishingEnabled = ((SubscriptionDiagnosticsDataTypeBuilder)b).publishingEnabled;
        this.modifyCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).modifyCount;
        this.enableCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).enableCount;
        this.disableCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).disableCount;
        this.republishRequestCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).republishRequestCount;
        this.republishMessageRequestCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).republishMessageRequestCount;
        this.republishMessageCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).republishMessageCount;
        this.transferRequestCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).transferRequestCount;
        this.transferredToAltClientCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).transferredToAltClientCount;
        this.transferredToSameClientCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).transferredToSameClientCount;
        this.publishRequestCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).publishRequestCount;
        this.dataChangeNotificationsCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).dataChangeNotificationsCount;
        this.eventNotificationsCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).eventNotificationsCount;
        this.notificationsCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).notificationsCount;
        this.latePublishRequestCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).latePublishRequestCount;
        this.currentKeepAliveCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).currentKeepAliveCount;
        this.currentLifetimeCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).currentLifetimeCount;
        this.unacknowledgedMessageCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).unacknowledgedMessageCount;
        this.discardedMessageCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).discardedMessageCount;
        this.monitoredItemCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).monitoredItemCount;
        this.disabledMonitoredItemCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).disabledMonitoredItemCount;
        this.monitoringQueueOverflowCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).monitoringQueueOverflowCount;
        this.nextSequenceNumber = ((SubscriptionDiagnosticsDataTypeBuilder)b).nextSequenceNumber;
        this.eventQueueOverflowCount = ((SubscriptionDiagnosticsDataTypeBuilder)b).eventQueueOverflowCount;
    }

    public static SubscriptionDiagnosticsDataTypeBuilder<?, ?> builder() {
        return new SubscriptionDiagnosticsDataTypeBuilderImpl();
    }

    public SubscriptionDiagnosticsDataTypeBuilder<?, ?> toBuilder() {
        return new SubscriptionDiagnosticsDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionDiagnosticsDataType)) {
            return false;
        }
        SubscriptionDiagnosticsDataType other = (SubscriptionDiagnosticsDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$publishingInterval = this.getPublishingInterval();
        Double other$publishingInterval = other.getPublishingInterval();
        if (this$publishingInterval == null ? other$publishingInterval != null : !((Object)this$publishingInterval).equals(other$publishingInterval)) {
            return false;
        }
        Boolean this$publishingEnabled = this.getPublishingEnabled();
        Boolean other$publishingEnabled = other.getPublishingEnabled();
        if (this$publishingEnabled == null ? other$publishingEnabled != null : !((Object)this$publishingEnabled).equals(other$publishingEnabled)) {
            return false;
        }
        NodeId this$sessionId = this.getSessionId();
        NodeId other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !((Object)this$sessionId).equals(other$sessionId)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UByte this$priority = this.getPriority();
        UByte other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
            return false;
        }
        UInteger this$maxKeepAliveCount = this.getMaxKeepAliveCount();
        UInteger other$maxKeepAliveCount = other.getMaxKeepAliveCount();
        if (this$maxKeepAliveCount == null ? other$maxKeepAliveCount != null : !((Object)this$maxKeepAliveCount).equals(other$maxKeepAliveCount)) {
            return false;
        }
        UInteger this$maxLifetimeCount = this.getMaxLifetimeCount();
        UInteger other$maxLifetimeCount = other.getMaxLifetimeCount();
        if (this$maxLifetimeCount == null ? other$maxLifetimeCount != null : !((Object)this$maxLifetimeCount).equals(other$maxLifetimeCount)) {
            return false;
        }
        UInteger this$maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        UInteger other$maxNotificationsPerPublish = other.getMaxNotificationsPerPublish();
        if (this$maxNotificationsPerPublish == null ? other$maxNotificationsPerPublish != null : !((Object)this$maxNotificationsPerPublish).equals(other$maxNotificationsPerPublish)) {
            return false;
        }
        UInteger this$modifyCount = this.getModifyCount();
        UInteger other$modifyCount = other.getModifyCount();
        if (this$modifyCount == null ? other$modifyCount != null : !((Object)this$modifyCount).equals(other$modifyCount)) {
            return false;
        }
        UInteger this$enableCount = this.getEnableCount();
        UInteger other$enableCount = other.getEnableCount();
        if (this$enableCount == null ? other$enableCount != null : !((Object)this$enableCount).equals(other$enableCount)) {
            return false;
        }
        UInteger this$disableCount = this.getDisableCount();
        UInteger other$disableCount = other.getDisableCount();
        if (this$disableCount == null ? other$disableCount != null : !((Object)this$disableCount).equals(other$disableCount)) {
            return false;
        }
        UInteger this$republishRequestCount = this.getRepublishRequestCount();
        UInteger other$republishRequestCount = other.getRepublishRequestCount();
        if (this$republishRequestCount == null ? other$republishRequestCount != null : !((Object)this$republishRequestCount).equals(other$republishRequestCount)) {
            return false;
        }
        UInteger this$republishMessageRequestCount = this.getRepublishMessageRequestCount();
        UInteger other$republishMessageRequestCount = other.getRepublishMessageRequestCount();
        if (this$republishMessageRequestCount == null ? other$republishMessageRequestCount != null : !((Object)this$republishMessageRequestCount).equals(other$republishMessageRequestCount)) {
            return false;
        }
        UInteger this$republishMessageCount = this.getRepublishMessageCount();
        UInteger other$republishMessageCount = other.getRepublishMessageCount();
        if (this$republishMessageCount == null ? other$republishMessageCount != null : !((Object)this$republishMessageCount).equals(other$republishMessageCount)) {
            return false;
        }
        UInteger this$transferRequestCount = this.getTransferRequestCount();
        UInteger other$transferRequestCount = other.getTransferRequestCount();
        if (this$transferRequestCount == null ? other$transferRequestCount != null : !((Object)this$transferRequestCount).equals(other$transferRequestCount)) {
            return false;
        }
        UInteger this$transferredToAltClientCount = this.getTransferredToAltClientCount();
        UInteger other$transferredToAltClientCount = other.getTransferredToAltClientCount();
        if (this$transferredToAltClientCount == null ? other$transferredToAltClientCount != null : !((Object)this$transferredToAltClientCount).equals(other$transferredToAltClientCount)) {
            return false;
        }
        UInteger this$transferredToSameClientCount = this.getTransferredToSameClientCount();
        UInteger other$transferredToSameClientCount = other.getTransferredToSameClientCount();
        if (this$transferredToSameClientCount == null ? other$transferredToSameClientCount != null : !((Object)this$transferredToSameClientCount).equals(other$transferredToSameClientCount)) {
            return false;
        }
        UInteger this$publishRequestCount = this.getPublishRequestCount();
        UInteger other$publishRequestCount = other.getPublishRequestCount();
        if (this$publishRequestCount == null ? other$publishRequestCount != null : !((Object)this$publishRequestCount).equals(other$publishRequestCount)) {
            return false;
        }
        UInteger this$dataChangeNotificationsCount = this.getDataChangeNotificationsCount();
        UInteger other$dataChangeNotificationsCount = other.getDataChangeNotificationsCount();
        if (this$dataChangeNotificationsCount == null ? other$dataChangeNotificationsCount != null : !((Object)this$dataChangeNotificationsCount).equals(other$dataChangeNotificationsCount)) {
            return false;
        }
        UInteger this$eventNotificationsCount = this.getEventNotificationsCount();
        UInteger other$eventNotificationsCount = other.getEventNotificationsCount();
        if (this$eventNotificationsCount == null ? other$eventNotificationsCount != null : !((Object)this$eventNotificationsCount).equals(other$eventNotificationsCount)) {
            return false;
        }
        UInteger this$notificationsCount = this.getNotificationsCount();
        UInteger other$notificationsCount = other.getNotificationsCount();
        if (this$notificationsCount == null ? other$notificationsCount != null : !((Object)this$notificationsCount).equals(other$notificationsCount)) {
            return false;
        }
        UInteger this$latePublishRequestCount = this.getLatePublishRequestCount();
        UInteger other$latePublishRequestCount = other.getLatePublishRequestCount();
        if (this$latePublishRequestCount == null ? other$latePublishRequestCount != null : !((Object)this$latePublishRequestCount).equals(other$latePublishRequestCount)) {
            return false;
        }
        UInteger this$currentKeepAliveCount = this.getCurrentKeepAliveCount();
        UInteger other$currentKeepAliveCount = other.getCurrentKeepAliveCount();
        if (this$currentKeepAliveCount == null ? other$currentKeepAliveCount != null : !((Object)this$currentKeepAliveCount).equals(other$currentKeepAliveCount)) {
            return false;
        }
        UInteger this$currentLifetimeCount = this.getCurrentLifetimeCount();
        UInteger other$currentLifetimeCount = other.getCurrentLifetimeCount();
        if (this$currentLifetimeCount == null ? other$currentLifetimeCount != null : !((Object)this$currentLifetimeCount).equals(other$currentLifetimeCount)) {
            return false;
        }
        UInteger this$unacknowledgedMessageCount = this.getUnacknowledgedMessageCount();
        UInteger other$unacknowledgedMessageCount = other.getUnacknowledgedMessageCount();
        if (this$unacknowledgedMessageCount == null ? other$unacknowledgedMessageCount != null : !((Object)this$unacknowledgedMessageCount).equals(other$unacknowledgedMessageCount)) {
            return false;
        }
        UInteger this$discardedMessageCount = this.getDiscardedMessageCount();
        UInteger other$discardedMessageCount = other.getDiscardedMessageCount();
        if (this$discardedMessageCount == null ? other$discardedMessageCount != null : !((Object)this$discardedMessageCount).equals(other$discardedMessageCount)) {
            return false;
        }
        UInteger this$monitoredItemCount = this.getMonitoredItemCount();
        UInteger other$monitoredItemCount = other.getMonitoredItemCount();
        if (this$monitoredItemCount == null ? other$monitoredItemCount != null : !((Object)this$monitoredItemCount).equals(other$monitoredItemCount)) {
            return false;
        }
        UInteger this$disabledMonitoredItemCount = this.getDisabledMonitoredItemCount();
        UInteger other$disabledMonitoredItemCount = other.getDisabledMonitoredItemCount();
        if (this$disabledMonitoredItemCount == null ? other$disabledMonitoredItemCount != null : !((Object)this$disabledMonitoredItemCount).equals(other$disabledMonitoredItemCount)) {
            return false;
        }
        UInteger this$monitoringQueueOverflowCount = this.getMonitoringQueueOverflowCount();
        UInteger other$monitoringQueueOverflowCount = other.getMonitoringQueueOverflowCount();
        if (this$monitoringQueueOverflowCount == null ? other$monitoringQueueOverflowCount != null : !((Object)this$monitoringQueueOverflowCount).equals(other$monitoringQueueOverflowCount)) {
            return false;
        }
        UInteger this$nextSequenceNumber = this.getNextSequenceNumber();
        UInteger other$nextSequenceNumber = other.getNextSequenceNumber();
        if (this$nextSequenceNumber == null ? other$nextSequenceNumber != null : !((Object)this$nextSequenceNumber).equals(other$nextSequenceNumber)) {
            return false;
        }
        UInteger this$eventQueueOverflowCount = this.getEventQueueOverflowCount();
        UInteger other$eventQueueOverflowCount = other.getEventQueueOverflowCount();
        return !(this$eventQueueOverflowCount == null ? other$eventQueueOverflowCount != null : !((Object)this$eventQueueOverflowCount).equals(other$eventQueueOverflowCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionDiagnosticsDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $publishingInterval = this.getPublishingInterval();
        result = result * 59 + ($publishingInterval == null ? 43 : ((Object)$publishingInterval).hashCode());
        Boolean $publishingEnabled = this.getPublishingEnabled();
        result = result * 59 + ($publishingEnabled == null ? 43 : ((Object)$publishingEnabled).hashCode());
        NodeId $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : ((Object)$sessionId).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UByte $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        UInteger $maxKeepAliveCount = this.getMaxKeepAliveCount();
        result = result * 59 + ($maxKeepAliveCount == null ? 43 : ((Object)$maxKeepAliveCount).hashCode());
        UInteger $maxLifetimeCount = this.getMaxLifetimeCount();
        result = result * 59 + ($maxLifetimeCount == null ? 43 : ((Object)$maxLifetimeCount).hashCode());
        UInteger $maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        result = result * 59 + ($maxNotificationsPerPublish == null ? 43 : ((Object)$maxNotificationsPerPublish).hashCode());
        UInteger $modifyCount = this.getModifyCount();
        result = result * 59 + ($modifyCount == null ? 43 : ((Object)$modifyCount).hashCode());
        UInteger $enableCount = this.getEnableCount();
        result = result * 59 + ($enableCount == null ? 43 : ((Object)$enableCount).hashCode());
        UInteger $disableCount = this.getDisableCount();
        result = result * 59 + ($disableCount == null ? 43 : ((Object)$disableCount).hashCode());
        UInteger $republishRequestCount = this.getRepublishRequestCount();
        result = result * 59 + ($republishRequestCount == null ? 43 : ((Object)$republishRequestCount).hashCode());
        UInteger $republishMessageRequestCount = this.getRepublishMessageRequestCount();
        result = result * 59 + ($republishMessageRequestCount == null ? 43 : ((Object)$republishMessageRequestCount).hashCode());
        UInteger $republishMessageCount = this.getRepublishMessageCount();
        result = result * 59 + ($republishMessageCount == null ? 43 : ((Object)$republishMessageCount).hashCode());
        UInteger $transferRequestCount = this.getTransferRequestCount();
        result = result * 59 + ($transferRequestCount == null ? 43 : ((Object)$transferRequestCount).hashCode());
        UInteger $transferredToAltClientCount = this.getTransferredToAltClientCount();
        result = result * 59 + ($transferredToAltClientCount == null ? 43 : ((Object)$transferredToAltClientCount).hashCode());
        UInteger $transferredToSameClientCount = this.getTransferredToSameClientCount();
        result = result * 59 + ($transferredToSameClientCount == null ? 43 : ((Object)$transferredToSameClientCount).hashCode());
        UInteger $publishRequestCount = this.getPublishRequestCount();
        result = result * 59 + ($publishRequestCount == null ? 43 : ((Object)$publishRequestCount).hashCode());
        UInteger $dataChangeNotificationsCount = this.getDataChangeNotificationsCount();
        result = result * 59 + ($dataChangeNotificationsCount == null ? 43 : ((Object)$dataChangeNotificationsCount).hashCode());
        UInteger $eventNotificationsCount = this.getEventNotificationsCount();
        result = result * 59 + ($eventNotificationsCount == null ? 43 : ((Object)$eventNotificationsCount).hashCode());
        UInteger $notificationsCount = this.getNotificationsCount();
        result = result * 59 + ($notificationsCount == null ? 43 : ((Object)$notificationsCount).hashCode());
        UInteger $latePublishRequestCount = this.getLatePublishRequestCount();
        result = result * 59 + ($latePublishRequestCount == null ? 43 : ((Object)$latePublishRequestCount).hashCode());
        UInteger $currentKeepAliveCount = this.getCurrentKeepAliveCount();
        result = result * 59 + ($currentKeepAliveCount == null ? 43 : ((Object)$currentKeepAliveCount).hashCode());
        UInteger $currentLifetimeCount = this.getCurrentLifetimeCount();
        result = result * 59 + ($currentLifetimeCount == null ? 43 : ((Object)$currentLifetimeCount).hashCode());
        UInteger $unacknowledgedMessageCount = this.getUnacknowledgedMessageCount();
        result = result * 59 + ($unacknowledgedMessageCount == null ? 43 : ((Object)$unacknowledgedMessageCount).hashCode());
        UInteger $discardedMessageCount = this.getDiscardedMessageCount();
        result = result * 59 + ($discardedMessageCount == null ? 43 : ((Object)$discardedMessageCount).hashCode());
        UInteger $monitoredItemCount = this.getMonitoredItemCount();
        result = result * 59 + ($monitoredItemCount == null ? 43 : ((Object)$monitoredItemCount).hashCode());
        UInteger $disabledMonitoredItemCount = this.getDisabledMonitoredItemCount();
        result = result * 59 + ($disabledMonitoredItemCount == null ? 43 : ((Object)$disabledMonitoredItemCount).hashCode());
        UInteger $monitoringQueueOverflowCount = this.getMonitoringQueueOverflowCount();
        result = result * 59 + ($monitoringQueueOverflowCount == null ? 43 : ((Object)$monitoringQueueOverflowCount).hashCode());
        UInteger $nextSequenceNumber = this.getNextSequenceNumber();
        result = result * 59 + ($nextSequenceNumber == null ? 43 : ((Object)$nextSequenceNumber).hashCode());
        UInteger $eventQueueOverflowCount = this.getEventQueueOverflowCount();
        result = result * 59 + ($eventQueueOverflowCount == null ? 43 : ((Object)$eventQueueOverflowCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SubscriptionDiagnosticsDataType(sessionId=" + this.getSessionId() + ", subscriptionId=" + this.getSubscriptionId() + ", priority=" + this.getPriority() + ", publishingInterval=" + this.getPublishingInterval() + ", maxKeepAliveCount=" + this.getMaxKeepAliveCount() + ", maxLifetimeCount=" + this.getMaxLifetimeCount() + ", maxNotificationsPerPublish=" + this.getMaxNotificationsPerPublish() + ", publishingEnabled=" + this.getPublishingEnabled() + ", modifyCount=" + this.getModifyCount() + ", enableCount=" + this.getEnableCount() + ", disableCount=" + this.getDisableCount() + ", republishRequestCount=" + this.getRepublishRequestCount() + ", republishMessageRequestCount=" + this.getRepublishMessageRequestCount() + ", republishMessageCount=" + this.getRepublishMessageCount() + ", transferRequestCount=" + this.getTransferRequestCount() + ", transferredToAltClientCount=" + this.getTransferredToAltClientCount() + ", transferredToSameClientCount=" + this.getTransferredToSameClientCount() + ", publishRequestCount=" + this.getPublishRequestCount() + ", dataChangeNotificationsCount=" + this.getDataChangeNotificationsCount() + ", eventNotificationsCount=" + this.getEventNotificationsCount() + ", notificationsCount=" + this.getNotificationsCount() + ", latePublishRequestCount=" + this.getLatePublishRequestCount() + ", currentKeepAliveCount=" + this.getCurrentKeepAliveCount() + ", currentLifetimeCount=" + this.getCurrentLifetimeCount() + ", unacknowledgedMessageCount=" + this.getUnacknowledgedMessageCount() + ", discardedMessageCount=" + this.getDiscardedMessageCount() + ", monitoredItemCount=" + this.getMonitoredItemCount() + ", disabledMonitoredItemCount=" + this.getDisabledMonitoredItemCount() + ", monitoringQueueOverflowCount=" + this.getMonitoringQueueOverflowCount() + ", nextSequenceNumber=" + this.getNextSequenceNumber() + ", eventQueueOverflowCount=" + this.getEventQueueOverflowCount() + ")";
    }

    private static final class SubscriptionDiagnosticsDataTypeBuilderImpl
    extends SubscriptionDiagnosticsDataTypeBuilder<SubscriptionDiagnosticsDataType, SubscriptionDiagnosticsDataTypeBuilderImpl> {
        private SubscriptionDiagnosticsDataTypeBuilderImpl() {
        }

        @Override
        protected SubscriptionDiagnosticsDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public SubscriptionDiagnosticsDataType build() {
            return new SubscriptionDiagnosticsDataType(this);
        }
    }

    public static abstract class SubscriptionDiagnosticsDataTypeBuilder<C extends SubscriptionDiagnosticsDataType, B extends SubscriptionDiagnosticsDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId sessionId;
        private UInteger subscriptionId;
        private UByte priority;
        private Double publishingInterval;
        private UInteger maxKeepAliveCount;
        private UInteger maxLifetimeCount;
        private UInteger maxNotificationsPerPublish;
        private Boolean publishingEnabled;
        private UInteger modifyCount;
        private UInteger enableCount;
        private UInteger disableCount;
        private UInteger republishRequestCount;
        private UInteger republishMessageRequestCount;
        private UInteger republishMessageCount;
        private UInteger transferRequestCount;
        private UInteger transferredToAltClientCount;
        private UInteger transferredToSameClientCount;
        private UInteger publishRequestCount;
        private UInteger dataChangeNotificationsCount;
        private UInteger eventNotificationsCount;
        private UInteger notificationsCount;
        private UInteger latePublishRequestCount;
        private UInteger currentKeepAliveCount;
        private UInteger currentLifetimeCount;
        private UInteger unacknowledgedMessageCount;
        private UInteger discardedMessageCount;
        private UInteger monitoredItemCount;
        private UInteger disabledMonitoredItemCount;
        private UInteger monitoringQueueOverflowCount;
        private UInteger nextSequenceNumber;
        private UInteger eventQueueOverflowCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SubscriptionDiagnosticsDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SubscriptionDiagnosticsDataType instance, SubscriptionDiagnosticsDataTypeBuilder<?, ?> b) {
            b.sessionId(instance.sessionId);
            b.subscriptionId(instance.subscriptionId);
            b.priority(instance.priority);
            b.publishingInterval(instance.publishingInterval);
            b.maxKeepAliveCount(instance.maxKeepAliveCount);
            b.maxLifetimeCount(instance.maxLifetimeCount);
            b.maxNotificationsPerPublish(instance.maxNotificationsPerPublish);
            b.publishingEnabled(instance.publishingEnabled);
            b.modifyCount(instance.modifyCount);
            b.enableCount(instance.enableCount);
            b.disableCount(instance.disableCount);
            b.republishRequestCount(instance.republishRequestCount);
            b.republishMessageRequestCount(instance.republishMessageRequestCount);
            b.republishMessageCount(instance.republishMessageCount);
            b.transferRequestCount(instance.transferRequestCount);
            b.transferredToAltClientCount(instance.transferredToAltClientCount);
            b.transferredToSameClientCount(instance.transferredToSameClientCount);
            b.publishRequestCount(instance.publishRequestCount);
            b.dataChangeNotificationsCount(instance.dataChangeNotificationsCount);
            b.eventNotificationsCount(instance.eventNotificationsCount);
            b.notificationsCount(instance.notificationsCount);
            b.latePublishRequestCount(instance.latePublishRequestCount);
            b.currentKeepAliveCount(instance.currentKeepAliveCount);
            b.currentLifetimeCount(instance.currentLifetimeCount);
            b.unacknowledgedMessageCount(instance.unacknowledgedMessageCount);
            b.discardedMessageCount(instance.discardedMessageCount);
            b.monitoredItemCount(instance.monitoredItemCount);
            b.disabledMonitoredItemCount(instance.disabledMonitoredItemCount);
            b.monitoringQueueOverflowCount(instance.monitoringQueueOverflowCount);
            b.nextSequenceNumber(instance.nextSequenceNumber);
            b.eventQueueOverflowCount(instance.eventQueueOverflowCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sessionId(NodeId sessionId) {
            this.sessionId = sessionId;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B priority(UByte priority) {
            this.priority = priority;
            return (B)this.self();
        }

        public B publishingInterval(Double publishingInterval) {
            this.publishingInterval = publishingInterval;
            return (B)this.self();
        }

        public B maxKeepAliveCount(UInteger maxKeepAliveCount) {
            this.maxKeepAliveCount = maxKeepAliveCount;
            return (B)this.self();
        }

        public B maxLifetimeCount(UInteger maxLifetimeCount) {
            this.maxLifetimeCount = maxLifetimeCount;
            return (B)this.self();
        }

        public B maxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
            this.maxNotificationsPerPublish = maxNotificationsPerPublish;
            return (B)this.self();
        }

        public B publishingEnabled(Boolean publishingEnabled) {
            this.publishingEnabled = publishingEnabled;
            return (B)this.self();
        }

        public B modifyCount(UInteger modifyCount) {
            this.modifyCount = modifyCount;
            return (B)this.self();
        }

        public B enableCount(UInteger enableCount) {
            this.enableCount = enableCount;
            return (B)this.self();
        }

        public B disableCount(UInteger disableCount) {
            this.disableCount = disableCount;
            return (B)this.self();
        }

        public B republishRequestCount(UInteger republishRequestCount) {
            this.republishRequestCount = republishRequestCount;
            return (B)this.self();
        }

        public B republishMessageRequestCount(UInteger republishMessageRequestCount) {
            this.republishMessageRequestCount = republishMessageRequestCount;
            return (B)this.self();
        }

        public B republishMessageCount(UInteger republishMessageCount) {
            this.republishMessageCount = republishMessageCount;
            return (B)this.self();
        }

        public B transferRequestCount(UInteger transferRequestCount) {
            this.transferRequestCount = transferRequestCount;
            return (B)this.self();
        }

        public B transferredToAltClientCount(UInteger transferredToAltClientCount) {
            this.transferredToAltClientCount = transferredToAltClientCount;
            return (B)this.self();
        }

        public B transferredToSameClientCount(UInteger transferredToSameClientCount) {
            this.transferredToSameClientCount = transferredToSameClientCount;
            return (B)this.self();
        }

        public B publishRequestCount(UInteger publishRequestCount) {
            this.publishRequestCount = publishRequestCount;
            return (B)this.self();
        }

        public B dataChangeNotificationsCount(UInteger dataChangeNotificationsCount) {
            this.dataChangeNotificationsCount = dataChangeNotificationsCount;
            return (B)this.self();
        }

        public B eventNotificationsCount(UInteger eventNotificationsCount) {
            this.eventNotificationsCount = eventNotificationsCount;
            return (B)this.self();
        }

        public B notificationsCount(UInteger notificationsCount) {
            this.notificationsCount = notificationsCount;
            return (B)this.self();
        }

        public B latePublishRequestCount(UInteger latePublishRequestCount) {
            this.latePublishRequestCount = latePublishRequestCount;
            return (B)this.self();
        }

        public B currentKeepAliveCount(UInteger currentKeepAliveCount) {
            this.currentKeepAliveCount = currentKeepAliveCount;
            return (B)this.self();
        }

        public B currentLifetimeCount(UInteger currentLifetimeCount) {
            this.currentLifetimeCount = currentLifetimeCount;
            return (B)this.self();
        }

        public B unacknowledgedMessageCount(UInteger unacknowledgedMessageCount) {
            this.unacknowledgedMessageCount = unacknowledgedMessageCount;
            return (B)this.self();
        }

        public B discardedMessageCount(UInteger discardedMessageCount) {
            this.discardedMessageCount = discardedMessageCount;
            return (B)this.self();
        }

        public B monitoredItemCount(UInteger monitoredItemCount) {
            this.monitoredItemCount = monitoredItemCount;
            return (B)this.self();
        }

        public B disabledMonitoredItemCount(UInteger disabledMonitoredItemCount) {
            this.disabledMonitoredItemCount = disabledMonitoredItemCount;
            return (B)this.self();
        }

        public B monitoringQueueOverflowCount(UInteger monitoringQueueOverflowCount) {
            this.monitoringQueueOverflowCount = monitoringQueueOverflowCount;
            return (B)this.self();
        }

        public B nextSequenceNumber(UInteger nextSequenceNumber) {
            this.nextSequenceNumber = nextSequenceNumber;
            return (B)this.self();
        }

        public B eventQueueOverflowCount(UInteger eventQueueOverflowCount) {
            this.eventQueueOverflowCount = eventQueueOverflowCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SubscriptionDiagnosticsDataType.SubscriptionDiagnosticsDataTypeBuilder(super=" + super.toString() + ", sessionId=" + this.sessionId + ", subscriptionId=" + this.subscriptionId + ", priority=" + this.priority + ", publishingInterval=" + this.publishingInterval + ", maxKeepAliveCount=" + this.maxKeepAliveCount + ", maxLifetimeCount=" + this.maxLifetimeCount + ", maxNotificationsPerPublish=" + this.maxNotificationsPerPublish + ", publishingEnabled=" + this.publishingEnabled + ", modifyCount=" + this.modifyCount + ", enableCount=" + this.enableCount + ", disableCount=" + this.disableCount + ", republishRequestCount=" + this.republishRequestCount + ", republishMessageRequestCount=" + this.republishMessageRequestCount + ", republishMessageCount=" + this.republishMessageCount + ", transferRequestCount=" + this.transferRequestCount + ", transferredToAltClientCount=" + this.transferredToAltClientCount + ", transferredToSameClientCount=" + this.transferredToSameClientCount + ", publishRequestCount=" + this.publishRequestCount + ", dataChangeNotificationsCount=" + this.dataChangeNotificationsCount + ", eventNotificationsCount=" + this.eventNotificationsCount + ", notificationsCount=" + this.notificationsCount + ", latePublishRequestCount=" + this.latePublishRequestCount + ", currentKeepAliveCount=" + this.currentKeepAliveCount + ", currentLifetimeCount=" + this.currentLifetimeCount + ", unacknowledgedMessageCount=" + this.unacknowledgedMessageCount + ", discardedMessageCount=" + this.discardedMessageCount + ", monitoredItemCount=" + this.monitoredItemCount + ", disabledMonitoredItemCount=" + this.disabledMonitoredItemCount + ", monitoringQueueOverflowCount=" + this.monitoringQueueOverflowCount + ", nextSequenceNumber=" + this.nextSequenceNumber + ", eventQueueOverflowCount=" + this.eventQueueOverflowCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SubscriptionDiagnosticsDataType> {
        @Override
        public Class<SubscriptionDiagnosticsDataType> getType() {
            return SubscriptionDiagnosticsDataType.class;
        }

        @Override
        public SubscriptionDiagnosticsDataType decode(SerializationContext context, UaDecoder decoder) {
            NodeId sessionId = decoder.readNodeId("SessionId");
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UByte priority = decoder.readByte("Priority");
            Double publishingInterval = decoder.readDouble("PublishingInterval");
            UInteger maxKeepAliveCount = decoder.readUInt32("MaxKeepAliveCount");
            UInteger maxLifetimeCount = decoder.readUInt32("MaxLifetimeCount");
            UInteger maxNotificationsPerPublish = decoder.readUInt32("MaxNotificationsPerPublish");
            Boolean publishingEnabled = decoder.readBoolean("PublishingEnabled");
            UInteger modifyCount = decoder.readUInt32("ModifyCount");
            UInteger enableCount = decoder.readUInt32("EnableCount");
            UInteger disableCount = decoder.readUInt32("DisableCount");
            UInteger republishRequestCount = decoder.readUInt32("RepublishRequestCount");
            UInteger republishMessageRequestCount = decoder.readUInt32("RepublishMessageRequestCount");
            UInteger republishMessageCount = decoder.readUInt32("RepublishMessageCount");
            UInteger transferRequestCount = decoder.readUInt32("TransferRequestCount");
            UInteger transferredToAltClientCount = decoder.readUInt32("TransferredToAltClientCount");
            UInteger transferredToSameClientCount = decoder.readUInt32("TransferredToSameClientCount");
            UInteger publishRequestCount = decoder.readUInt32("PublishRequestCount");
            UInteger dataChangeNotificationsCount = decoder.readUInt32("DataChangeNotificationsCount");
            UInteger eventNotificationsCount = decoder.readUInt32("EventNotificationsCount");
            UInteger notificationsCount = decoder.readUInt32("NotificationsCount");
            UInteger latePublishRequestCount = decoder.readUInt32("LatePublishRequestCount");
            UInteger currentKeepAliveCount = decoder.readUInt32("CurrentKeepAliveCount");
            UInteger currentLifetimeCount = decoder.readUInt32("CurrentLifetimeCount");
            UInteger unacknowledgedMessageCount = decoder.readUInt32("UnacknowledgedMessageCount");
            UInteger discardedMessageCount = decoder.readUInt32("DiscardedMessageCount");
            UInteger monitoredItemCount = decoder.readUInt32("MonitoredItemCount");
            UInteger disabledMonitoredItemCount = decoder.readUInt32("DisabledMonitoredItemCount");
            UInteger monitoringQueueOverflowCount = decoder.readUInt32("MonitoringQueueOverflowCount");
            UInteger nextSequenceNumber = decoder.readUInt32("NextSequenceNumber");
            UInteger eventQueueOverflowCount = decoder.readUInt32("EventQueueOverflowCount");
            return new SubscriptionDiagnosticsDataType(sessionId, subscriptionId, priority, publishingInterval, maxKeepAliveCount, maxLifetimeCount, maxNotificationsPerPublish, publishingEnabled, modifyCount, enableCount, disableCount, republishRequestCount, republishMessageRequestCount, republishMessageCount, transferRequestCount, transferredToAltClientCount, transferredToSameClientCount, publishRequestCount, dataChangeNotificationsCount, eventNotificationsCount, notificationsCount, latePublishRequestCount, currentKeepAliveCount, currentLifetimeCount, unacknowledgedMessageCount, discardedMessageCount, monitoredItemCount, disabledMonitoredItemCount, monitoringQueueOverflowCount, nextSequenceNumber, eventQueueOverflowCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SubscriptionDiagnosticsDataType value) {
            encoder.writeNodeId("SessionId", value.getSessionId());
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeByte("Priority", value.getPriority());
            encoder.writeDouble("PublishingInterval", value.getPublishingInterval());
            encoder.writeUInt32("MaxKeepAliveCount", value.getMaxKeepAliveCount());
            encoder.writeUInt32("MaxLifetimeCount", value.getMaxLifetimeCount());
            encoder.writeUInt32("MaxNotificationsPerPublish", value.getMaxNotificationsPerPublish());
            encoder.writeBoolean("PublishingEnabled", value.getPublishingEnabled());
            encoder.writeUInt32("ModifyCount", value.getModifyCount());
            encoder.writeUInt32("EnableCount", value.getEnableCount());
            encoder.writeUInt32("DisableCount", value.getDisableCount());
            encoder.writeUInt32("RepublishRequestCount", value.getRepublishRequestCount());
            encoder.writeUInt32("RepublishMessageRequestCount", value.getRepublishMessageRequestCount());
            encoder.writeUInt32("RepublishMessageCount", value.getRepublishMessageCount());
            encoder.writeUInt32("TransferRequestCount", value.getTransferRequestCount());
            encoder.writeUInt32("TransferredToAltClientCount", value.getTransferredToAltClientCount());
            encoder.writeUInt32("TransferredToSameClientCount", value.getTransferredToSameClientCount());
            encoder.writeUInt32("PublishRequestCount", value.getPublishRequestCount());
            encoder.writeUInt32("DataChangeNotificationsCount", value.getDataChangeNotificationsCount());
            encoder.writeUInt32("EventNotificationsCount", value.getEventNotificationsCount());
            encoder.writeUInt32("NotificationsCount", value.getNotificationsCount());
            encoder.writeUInt32("LatePublishRequestCount", value.getLatePublishRequestCount());
            encoder.writeUInt32("CurrentKeepAliveCount", value.getCurrentKeepAliveCount());
            encoder.writeUInt32("CurrentLifetimeCount", value.getCurrentLifetimeCount());
            encoder.writeUInt32("UnacknowledgedMessageCount", value.getUnacknowledgedMessageCount());
            encoder.writeUInt32("DiscardedMessageCount", value.getDiscardedMessageCount());
            encoder.writeUInt32("MonitoredItemCount", value.getMonitoredItemCount());
            encoder.writeUInt32("DisabledMonitoredItemCount", value.getDisabledMonitoredItemCount());
            encoder.writeUInt32("MonitoringQueueOverflowCount", value.getMonitoringQueueOverflowCount());
            encoder.writeUInt32("NextSequenceNumber", value.getNextSequenceNumber());
            encoder.writeUInt32("EventQueueOverflowCount", value.getEventQueueOverflowCount());
        }
    }
}

