/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.udf.api.relational.table.TableFunctionHandle;
import org.apache.iotdb.udf.api.relational.table.argument.DescribedSchema;

public class TableFunctionAnalysis {
    private final Optional<DescribedSchema> properColumnSchema;
    private final Map<String, List<Integer>> requiredColumns;
    private final boolean requireRecordSnapshot;
    private final TableFunctionHandle handle;

    private TableFunctionAnalysis(Optional<DescribedSchema> properColumnSchema, Map<String, List<Integer>> requiredColumns, boolean requiredRecordSnapshot, TableFunctionHandle handle) {
        this.properColumnSchema = Objects.requireNonNull(properColumnSchema, "returnedType is null");
        this.requiredColumns = requiredColumns;
        this.requireRecordSnapshot = requiredRecordSnapshot;
        this.handle = Objects.requireNonNull(handle, "TableFunctionHandle is null");
    }

    public Optional<DescribedSchema> getProperColumnSchema() {
        return this.properColumnSchema;
    }

    public Map<String, List<Integer>> getRequiredColumns() {
        return this.requiredColumns;
    }

    public boolean isRequireRecordSnapshot() {
        return this.requireRecordSnapshot;
    }

    public TableFunctionHandle getTableFunctionHandle() {
        return this.handle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DescribedSchema properColumnSchema;
        private final Map<String, List<Integer>> requiredColumns = new HashMap<String, List<Integer>>();
        private boolean requireRecordSnapshot = true;
        private TableFunctionHandle executionInfo;

        private Builder() {
        }

        public Builder properColumnSchema(DescribedSchema properColumnSchema) {
            this.properColumnSchema = properColumnSchema;
            return this;
        }

        public Builder requiredColumns(String tableArgument, List<Integer> columns) {
            this.requiredColumns.put(tableArgument, columns);
            return this;
        }

        public Builder requireRecordSnapshot(boolean requireRecordSnapshot) {
            this.requireRecordSnapshot = requireRecordSnapshot;
            return this;
        }

        public Builder handle(TableFunctionHandle executionInfo) {
            this.executionInfo = executionInfo;
            return this;
        }

        public TableFunctionAnalysis build() {
            return new TableFunctionAnalysis(Optional.ofNullable(this.properColumnSchema), this.requiredColumns, this.requireRecordSnapshot, this.executionInfo);
        }
    }
}

