/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.SortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.StreamSortNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TopKNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class MergeLimitOverProjectWithSort
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<SortNode> SORT = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT).matching(ProjectNode::isIdentity).with(Patterns.source().matching(Patterns.sort().capturedAs(SORT)))));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode project = captures.get(PROJECT);
        SortNode sortNode = captures.get(SORT);
        if (sortNode instanceof StreamSortNode) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new TopKNode(parent.getPlanNodeId(), sortNode.getChildren(), sortNode.getOrderingScheme(), parent.getCount(), sortNode.getOutputSymbols(), sortNode.isOrderByAllIdsAndTime()))));
    }
}

