/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.json.DTOConverter;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.util.DurationParser;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.ExecutionDetailsDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class TasksRoutes
implements Routes {
    private static final Duration MAXIMUM_AWAIT_TIMEOUT = Duration.ofDays(365L);
    public static final String BASE = "/tasks";
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;
    private final DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationDTOConverter;

    @Inject
    public TasksRoutes(TaskManager taskManager, JsonTransformer jsonTransformer, @Named(value="webadmin-dto") DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationDTOConverter) {
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
        this.additionalInformationDTOConverter = additionalInformationDTOConverter;
    }

    @Override
    public String getBasePath() {
        return BASE;
    }

    @Override
    public void define(Service service) {
        service.get("/tasks/:id", this::getStatus, (ResponseTransformer)this.jsonTransformer);
        service.get("/tasks/:id/await", this::await, (ResponseTransformer)this.jsonTransformer);
        service.delete("/tasks/:id", this::cancel, (ResponseTransformer)this.jsonTransformer);
        service.get(BASE, this::list, (ResponseTransformer)this.jsonTransformer);
    }

    public Object list(Request req, Response response) {
        try {
            return ExecutionDetailsDto.from(this.additionalInformationDTOConverter, Optional.ofNullable(req.queryParams("status")).map(TaskManager.Status::fromString).map(arg_0 -> ((TaskManager)this.taskManager).list(arg_0)).orElse(this.taskManager.list()));
        }
        catch (IllegalArgumentException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).cause(e).message("Invalid status query parameter").haltError();
        }
    }

    public Object getStatus(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        return this.respondStatus(taskId, () -> this.taskManager.getExecutionDetails(this.getTaskId(req)));
    }

    public Object await(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        Duration timeout = this.getTimeout(req);
        return this.respondStatus(taskId, () -> this.awaitTask(taskId, timeout));
    }

    private Object respondStatus(TaskId taskId, Supplier<TaskExecutionDetails> executionDetailsSupplier) {
        try {
            TaskExecutionDetails executionDetails = executionDetailsSupplier.get();
            return ExecutionDetailsDto.from(this.additionalInformationDTOConverter, executionDetails);
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().message("%s can not be found", taskId.getValue()).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
        }
    }

    public Object cancel(Request req, Response response) {
        TaskId taskId = this.getTaskId(req);
        this.taskManager.cancel(taskId);
        return Responses.returnNoContent(response);
    }

    private TaskId getTaskId(Request req) {
        try {
            String id = req.params("id");
            return TaskId.fromString((String)id);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid task id").haltError();
        }
    }

    private Duration getTimeout(Request req) {
        try {
            Duration timeout = Optional.ofNullable(req.queryParams("timeout")).filter(Predicate.not(String::isEmpty)).map(rawString -> DurationParser.parse((String)rawString, (ChronoUnit)ChronoUnit.SECONDS)).orElse(MAXIMUM_AWAIT_TIMEOUT);
            this.assertDoesNotExceedMaximumTimeout(timeout);
            return timeout;
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Invalid timeout").haltError();
        }
    }

    private void assertDoesNotExceedMaximumTimeout(Duration timeout) {
        Preconditions.checkState((timeout.compareTo(MAXIMUM_AWAIT_TIMEOUT) <= 0 ? 1 : 0) != 0, (Object)"Timeout should not exceed 365 days");
    }

    private TaskExecutionDetails awaitTask(TaskId taskId, Duration timeout) {
        try {
            return this.taskManager.await(taskId, timeout);
        }
        catch (TaskManager.ReachedTimeoutException e) {
            throw ErrorResponder.builder().statusCode(408).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The timeout has been reached").haltError();
        }
        catch (TaskNotFoundException e) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.SERVER_ERROR).message("The taskId is not found").haltError();
        }
    }
}

