/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.transport.mailets.RecipientRewriteTableProcessor;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class RecipientRewriteTable
extends GenericMailet {
    public static final String ERROR_PROCESSOR = "errorProcessor";
    private final org.apache.james.rrt.api.RecipientRewriteTable virtualTableStore;
    private final DomainList domainList;
    private RecipientRewriteTableProcessor processor;

    @Inject
    public RecipientRewriteTable(org.apache.james.rrt.api.RecipientRewriteTable virtualTableStore, DomainList domainList) {
        this.virtualTableStore = virtualTableStore;
        this.domainList = domainList;
    }

    public void init() throws MessagingException {
        String errorProcessor = this.getInitParameter(ERROR_PROCESSOR, "error");
        this.processor = new RecipientRewriteTableProcessor(this.virtualTableStore, this.domainList, this.getMailetContext(), errorProcessor);
    }

    public void service(Mail mail) throws MessagingException {
        Preconditions.checkNotNull((Object)mail);
        MimeMessage message = mail.getMessage();
        if (message != null) {
            this.processor.processMail(mail);
        }
    }

    public String getMailetInfo() {
        return "RecipientRewriteTable Mailet";
    }
}

