/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import java.net.SocketAddress;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class MicrometerPooledConnectionProviderMeterRegistrar {
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        String[] tags = new String[]{"id", id, "remote.address", addressAsString, "name", poolName};
        Gauge.builder((String)"reactor.netty.connection.provider.total.connections", (Object)metrics, InstrumentedPool.PoolMetrics::allocatedSize).description("The number of all connections, active or idle.").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.active.connections", (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description("The number of the connections that have been successfully acquired and are in active use").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.idle.connections", (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).description("The number of the idle connections").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.pending.connections", (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description("The number of the request, that are pending acquire a connection").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.max.connections", (Object)metrics, InstrumentedPool.PoolMetrics::getMaxAllocatedSize).description("The maximum number of active connections that are allowed").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)"reactor.netty.connection.provider.max.pending.connections", (Object)metrics, InstrumentedPool.PoolMetrics::getMaxPendingAcquireSize).description("The maximum number of requests that will be queued while waiting for a ready connection").tags(tags).register(Metrics.REGISTRY);
    }
}

