/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.incubator.codec.quic.DefaultQuicStreamFrame;

public interface QuicStreamFrame
extends ByteBufHolder {
    public static final QuicStreamFrame EMPTY_FIN = new QuicStreamFrame(){

        @Override
        public boolean hasFin() {
            return true;
        }

        @Override
        public QuicStreamFrame copy() {
            return this;
        }

        @Override
        public QuicStreamFrame duplicate() {
            return this;
        }

        @Override
        public QuicStreamFrame retainedDuplicate() {
            return this;
        }

        @Override
        public QuicStreamFrame replace(ByteBuf content) {
            return new DefaultQuicStreamFrame(content, this.hasFin());
        }

        @Override
        public QuicStreamFrame retain() {
            return this;
        }

        @Override
        public QuicStreamFrame retain(int increment) {
            return this;
        }

        @Override
        public QuicStreamFrame touch() {
            return this;
        }

        @Override
        public QuicStreamFrame touch(Object hint) {
            return this;
        }

        public ByteBuf content() {
            return Unpooled.EMPTY_BUFFER;
        }

        public int refCnt() {
            return 1;
        }

        public boolean release() {
            return false;
        }

        public boolean release(int decrement) {
            return false;
        }
    };

    public boolean hasFin();

    public QuicStreamFrame copy();

    public QuicStreamFrame duplicate();

    public QuicStreamFrame retainedDuplicate();

    public QuicStreamFrame replace(ByteBuf var1);

    public QuicStreamFrame retain();

    public QuicStreamFrame retain(int var1);

    public QuicStreamFrame touch();

    public QuicStreamFrame touch(Object var1);
}

