/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type;

import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultVectorType
implements VectorType {
    public static final String VECTOR_CLASS_NAME = "org.apache.cassandra.db.marshal.VectorType";
    private final DataType subtype;
    private final int dimensions;

    public DefaultVectorType(DataType subtype, int dimensions) {
        this.dimensions = dimensions;
        this.subtype = subtype;
    }

    @Override
    public DataType getElementType() {
        return this.subtype;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    @NonNull
    public String getClassName() {
        return VECTOR_CLASS_NAME;
    }

    @Override
    @NonNull
    public String asCql(boolean includeFrozen, boolean pretty) {
        return String.format("vector<%s, %d>", this.getElementType().asCql(true, false), this.getDimensions());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultVectorType) {
            DefaultVectorType that = (DefaultVectorType)o;
            return that.subtype.equals(this.subtype) && that.dimensions == this.dimensions;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(DefaultVectorType.class, this.subtype, this.dimensions);
    }

    public String toString() {
        return String.format("Vector(%s, %d)", this.getElementType(), this.getDimensions());
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
    }
}

