/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.projections;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.mailbox.model.MessageId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageFastViewProjection {
    public static final String MESSAGE_FAST_VIEW_PROJECTION = "MessageFastViewProjection";
    public static final String METRIC_RETRIEVE_HIT_COUNT = "MessageFastViewProjection:retrieveHitCount";
    public static final String METRIC_RETRIEVE_MISS_COUNT = "MessageFastViewProjection:retrieveMissCount";

    public Publisher<Void> store(MessageId var1, MessageFastViewPrecomputedProperties var2);

    public Publisher<MessageFastViewPrecomputedProperties> retrieve(MessageId var1);

    public Publisher<Void> delete(MessageId var1);

    @VisibleForTesting
    public Publisher<Void> clear();

    default public Publisher<Map<MessageId, MessageFastViewPrecomputedProperties>> retrieve(Collection<MessageId> messageIds) {
        Preconditions.checkNotNull(messageIds);
        return Flux.fromIterable(messageIds).flatMap(messageId -> Mono.from(this.retrieve((MessageId)messageId)).map(preview -> Pair.of((Object)messageId, (Object)preview)), 16).collectMap(Pair::getLeft, Pair::getRight);
    }
}

