/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import jakarta.inject.Inject;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.cassandra.CassandraMailRepository;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryKeysDAO;
import org.apache.james.mailrepository.cassandra.CassandraMailRepositoryMailDaoV2;

public class CassandraMailRepositoryFactory
implements MailRepositoryFactory {
    private final CassandraMailRepositoryKeysDAO keysDAO;
    private final CassandraMailRepositoryMailDaoV2 mailDAO;
    private final MimeMessageStore.Factory mimeMessageStoreFactory;

    @Inject
    public CassandraMailRepositoryFactory(CassandraMailRepositoryKeysDAO keysDAO, CassandraMailRepositoryMailDaoV2 mailDAO, MimeMessageStore.Factory mimeMessageStoreFactory) {
        this.keysDAO = keysDAO;
        this.mailDAO = mailDAO;
        this.mimeMessageStoreFactory = mimeMessageStoreFactory;
    }

    public Class<? extends MailRepository> mailRepositoryClass() {
        return CassandraMailRepository.class;
    }

    public MailRepository create(MailRepositoryUrl url) {
        return new CassandraMailRepository(url, this.keysDAO, this.mailDAO, this.mimeMessageStoreFactory);
    }
}

