/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.webadmin.service.UsernameChangeService;
import reactor.core.publisher.Mono;

public class UsernameChangeTask
implements Task {
    static final TaskType TYPE = TaskType.of((String)"UsernameChangeTask");
    private final Username oldUser;
    private final Username newUser;
    private final UsernameChangeService.Performer performer;
    private final Optional<UsernameChangeTaskStep.StepName> fromStep;

    public UsernameChangeTask(UsernameChangeService service, Username oldUser, Username newUser, Optional<UsernameChangeTaskStep.StepName> fromStep) {
        this.oldUser = oldUser;
        this.newUser = newUser;
        this.performer = service.performer(fromStep);
        this.fromStep = fromStep;
    }

    public Task.Result run() {
        return (Task.Result)this.performer.changeUsername(this.oldUser, this.newUser).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(e -> {
            LOGGER.error("Error while changing username {} into {}", new Object[]{this.oldUser.asString(), this.newUser.asString(), e});
            return Mono.just((Object)Task.Result.PARTIAL);
        }).block();
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(Clock.systemUTC().instant(), this.oldUser, this.newUser, this.performer.getStatus().getStates(), this.fromStep));
    }

    public Username getOldUser() {
        return this.oldUser;
    }

    public Username getNewUser() {
        return this.newUser;
    }

    public Optional<UsernameChangeTaskStep.StepName> getFromStep() {
        return this.fromStep;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final Username oldUser;
        private final Username newUser;
        private final Map<UsernameChangeTaskStep.StepName, UsernameChangeService.StepState> status;
        private final Optional<UsernameChangeTaskStep.StepName> fromStep;

        public AdditionalInformation(Instant timestamp, Username oldUser, Username newUser, Map<UsernameChangeTaskStep.StepName, UsernameChangeService.StepState> status, Optional<UsernameChangeTaskStep.StepName> fromStep) {
            this.timestamp = timestamp;
            this.oldUser = oldUser;
            this.newUser = newUser;
            this.status = status;
            this.fromStep = fromStep;
        }

        public Optional<UsernameChangeTaskStep.StepName> getFromStep() {
            return this.fromStep;
        }

        public Username getOldUser() {
            return this.oldUser;
        }

        public Username getNewUser() {
            return this.newUser;
        }

        public Map<UsernameChangeTaskStep.StepName, UsernameChangeService.StepState> getStatus() {
            return this.status;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

