/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.maven;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporter;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporterArgs;
import org.apache.logging.log4j.changelog.exporter.ChangelogExporterTemplate;
import org.apache.logging.log4j.changelog.maven.AbstractChangelogMojo;
import org.apache.logging.log4j.changelog.maven.TemplateMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export", defaultPhase=LifecyclePhase.PRE_SITE, threadSafe=true)
public final class ExportMojo
extends AbstractChangelogMojo {
    private static final String SOURCE_TARGET_TEMPLATE_PATTERN = "^\\.(.*)\\." + ChangelogFiles.templateFileNameExtension() + '$';
    @Parameter(required=true)
    private List<TemplateMojo> indexTemplates;
    @Parameter(required=true)
    private List<TemplateMojo> changelogTemplates;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/site/changelog", property="log4j.changelog.outputDirectory", required=true)
    private File outputDirectory;

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping changelog export");
            return;
        }
        Set<ChangelogExporterTemplate> translatedIndexTemplates = ExportMojo.toExporterTemplates(this.indexTemplates);
        Set<ChangelogExporterTemplate> translatedReleaseChangelogTemplates = ExportMojo.toExporterTemplates(this.changelogTemplates);
        ChangelogExporterArgs args = new ChangelogExporterArgs(this.changelogDirectory.toPath(), translatedIndexTemplates, translatedReleaseChangelogTemplates, this.outputDirectory.toPath());
        ChangelogExporter.performExport((ChangelogExporterArgs)args);
    }

    private static Set<ChangelogExporterTemplate> toExporterTemplates(Collection<TemplateMojo> templateMojos) {
        return templateMojos.stream().map(ExportMojo::toExporterTemplate).collect(Collectors.toSet());
    }

    private static ChangelogExporterTemplate toExporterTemplate(TemplateMojo templateMojo) {
        String target = templateMojo.target == null ? templateMojo.source.replaceAll(SOURCE_TARGET_TEMPLATE_PATTERN, "$1") : templateMojo.target;
        return new ChangelogExporterTemplate(templateMojo.source, target, templateMojo.failIfNotFound);
    }
}

