/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.registry.StaticMicroservice;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.version.Version;

public class StaticMicroserviceVersions
extends MicroserviceVersions {
    private Class<?> schemaIntfCls;
    private String environment;

    public StaticMicroserviceVersions(AppManager appManager, String appId, String microserviceName, Class<?> schemaIntfCls) {
        super(appManager, appId, microserviceName);
        this.validated = true;
        this.schemaIntfCls = schemaIntfCls;
        this.environment = RegistryUtils.getMicroservice().getEnvironment();
    }

    @Override
    public void pullInstances() {
    }

    public void addInstances(String version, List<MicroserviceInstance> addedInstances) {
        Version parsedVersion = new Version(version);
        String serviceId = this.computeServiceId(parsedVersion);
        for (MicroserviceInstance instance : addedInstances) {
            instance.setServiceId(serviceId);
            instance.setInstanceId(serviceId + "-" + UUID.randomUUID());
        }
        this.mergeInstances(addedInstances);
        this.versions.computeIfAbsent(serviceId, microserviceId -> {
            StaticMicroservice microservice = this.createMicroservice(parsedVersion, serviceId);
            return this.appManager.getStaticMicroserviceVersionFactory().create(microservice);
        });
        for (MicroserviceVersionRule microserviceVersionRule : this.versionRules.values()) {
            microserviceVersionRule.update(this.versions, this.instances);
        }
    }

    private void mergeInstances(List<MicroserviceInstance> instances) {
        if (null == this.instances) {
            this.instances = new ArrayList(instances.size());
        }
        this.instances.addAll(instances);
    }

    private StaticMicroservice createMicroservice(Version parsedVersion, String serviceId) {
        StaticMicroservice microservice = new StaticMicroservice();
        microservice.setAppId(this.getAppId());
        microservice.setServiceId(serviceId);
        microservice.setServiceName(this.getMicroserviceName());
        microservice.setVersion(parsedVersion.getVersion());
        microservice.setEnvironment(RegistryUtils.getMicroservice().getEnvironment());
        microservice.setSchemaIntfCls(this.schemaIntfCls);
        return microservice;
    }

    private String computeServiceId(Version parsedVersion) {
        return this.getAppId() + "-" + this.environment + "-" + this.getMicroserviceName() + "-" + parsedVersion.getVersion();
    }
}

