/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.starter.registry;

import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryIntializer {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryIntializer.class);

    private RegistryIntializer() {
    }

    public static void initRegistry() {
        String address = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.rest.address", null).get();
        if (null != address) {
            try {
                RegistryUtils.init();
                RegistryUtils.getMicroserviceInstance().getEndpoints().add(RegistryUtils.getPublishAddress((String)"rest", (String)address));
                RegistryUtils.run();
            }
            catch (Exception e) {
                LOG.error("init registry error.", (Throwable)e);
            }
        } else {
            LOG.info("rest address is null.Service is not registered to service center");
        }
    }
}

