/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;
import org.apache.servicecomb.common.rest.UploadConfig;
import org.apache.servicecomb.common.rest.filter.HttpServerFilter;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.transport.rest.vertx.RestBodyHandler;
import org.apache.servicecomb.transport.rest.vertx.VertxHttpDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVertxHttpDispatcher
implements VertxHttpDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVertxHttpDispatcher.class);
    protected List<HttpServerFilter> httpServerFilters = SPIServiceUtils.getSortedService(HttpServerFilter.class);

    protected BodyHandler createBodyHandler() {
        RestBodyHandler bodyHandler = new RestBodyHandler();
        UploadConfig uploadConfig = new UploadConfig();
        bodyHandler.setUploadsDirectory(uploadConfig.getLocation());
        bodyHandler.setDeleteUploadedFilesOnEnd(true);
        bodyHandler.setBodyLimit(uploadConfig.getMaxSize());
        if (uploadConfig.toMultipartConfigElement() != null) {
            LOGGER.info("set uploads directory to \"{}\".", (Object)uploadConfig.getLocation());
        }
        return bodyHandler;
    }
}

