/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx.accesslog;

import com.netflix.config.DynamicPropertyFactory;

public final class AccessLogConfiguration {
    private static final String BASE = "servicecomb.accesslog.";
    private static final String ACCESSLOG_ENABLED = "servicecomb.accesslog.enabled";
    private static final String ACCESSLOG_PATTERN = "servicecomb.accesslog.pattern";
    public static final AccessLogConfiguration INSTANCE = new AccessLogConfiguration();
    public static final String DEFAULT_PATTERN = "%h - - %t %r %s %B %D";

    private AccessLogConfiguration() {
    }

    public boolean getAccessLogEnabled() {
        return this.getBooleanProperty(false, ACCESSLOG_ENABLED);
    }

    public String getAccesslogPattern() {
        return this.getProperty(DEFAULT_PATTERN, ACCESSLOG_PATTERN);
    }

    private String getProperty(String defaultValue, String key) {
        return DynamicPropertyFactory.getInstance().getStringProperty(key, defaultValue).get();
    }

    private boolean getBooleanProperty(boolean defaultValue, String key) {
        return DynamicPropertyFactory.getInstance().getBooleanProperty(key, defaultValue).get();
    }
}

