/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.protostuff.SchemaEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.runtime.FieldMapEx;
import io.protostuff.runtime.FieldSchema;
import java.util.ArrayList;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.bean.MapGetter;
import org.apache.servicecomb.foundation.common.utils.bean.MapSetter;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.MessageAsFieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.schema.PropertyWrapperAsFieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.schema.any.AnySchema;
import org.apache.servicecomb.foundation.protobuf.internal.schema.map.MapEntry;
import org.apache.servicecomb.foundation.protobuf.internal.schema.map.MapSchema;

public abstract class SchemaManager {
    protected final ProtoMapper protoMapper;
    protected final Proto proto;
    protected Map<String, SchemaEx<?>> canonicalSchemas = new ConcurrentHashMapEx();

    public SchemaManager(ProtoMapper protoMapper) {
        this.protoMapper = protoMapper;
        this.proto = protoMapper.getProto();
    }

    public Map<String, SchemaEx<?>> getCanonicalSchemas() {
        return this.canonicalSchemas;
    }

    protected String generateCacheKey(Message message, JavaType javaType) {
        return message.getCanonicalName() + ":" + javaType.toCanonical();
    }

    protected abstract <T> SchemaEx<T> newMessageSchema(Message var1, JavaType var2);

    protected abstract <T> FieldSchema<T> createScalarField(Field var1, PropertyDescriptor var2);

    protected <T> SchemaEx<T> getOrCreateMessageSchema(Message message, JavaType javaType) {
        String cacheKey = this.generateCacheKey(message, javaType);
        SchemaEx<Object> messageSchema = this.canonicalSchemas.get(cacheKey);
        if (messageSchema == null) {
            messageSchema = this.createMessageSchema(message, javaType);
        }
        return messageSchema;
    }

    protected <T> SchemaEx<T> findSchema(String key) {
        return this.canonicalSchemas.get(key);
    }

    protected <T> SchemaEx<T> createMessageSchema(Message message, JavaType javaType) {
        String cacheKey = this.generateCacheKey(message, javaType);
        SchemaEx<T> schema = this.findSchema(cacheKey);
        if (schema != null) {
            return schema;
        }
        schema = this.newMessageSchema(message, javaType);
        this.canonicalSchemas.put(cacheKey, schema);
        schema.init();
        return schema;
    }

    protected <T> FieldSchema<T> createMapFieldSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (javaType.isJavaLangObject()) {
            javaType = ProtoConst.MAP_TYPE;
        }
        JavaType entryType = TypeFactory.defaultInstance().constructParametricType(MapEntry.class, new JavaType[]{javaType.getKeyType(), javaType.getContentType()});
        SchemaEx<Map.Entry<Object, Object>> entrySchema = this.getOrCreateMessageSchema((Message)protoField.getType(), entryType);
        return new MapSchema(protoField, propertyDescriptor, entrySchema);
    }

    public FieldMapEx<Map<Object, Object>> createMapFields(Message message) {
        ArrayList fieldSchemas = new ArrayList();
        for (Field protoField : message.getFields()) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
            propertyDescriptor.setJavaType(ProtoConst.OBJECT_TYPE);
            propertyDescriptor.setGetter(new MapGetter((Object)protoField.getName()));
            propertyDescriptor.setSetter(new MapSetter((Object)protoField.getName()));
            FieldSchema fieldSchema = this.createSchemaField(protoField, propertyDescriptor);
            fieldSchemas.add(fieldSchema);
        }
        return FieldMapEx.createFieldMap(fieldSchemas);
    }

    public <T> FieldSchema<T> createSchemaField(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (protoField.isMap()) {
            return this.createMapFieldSchema(protoField, propertyDescriptor);
        }
        if (protoField.isRepeated()) {
            return this.createRepeatedSchema(protoField, propertyDescriptor);
        }
        if (ProtoUtils.isAnyField(protoField)) {
            return new AnySchema(this.protoMapper, protoField, propertyDescriptor);
        }
        if (protoField.getType().isScalar()) {
            return this.createScalarField(protoField, propertyDescriptor);
        }
        if (protoField.getType().isMessage()) {
            SchemaEx<Object> messageSchema = this.getOrCreateMessageSchema((Message)protoField.getType(), propertyDescriptor.getJavaType());
            if (ProtoUtils.isWrapProperty((FieldContainer)((Message)protoField.getType()))) {
                return new PropertyWrapperAsFieldSchema(protoField, propertyDescriptor, messageSchema);
            }
            return new MessageAsFieldSchema(protoField, propertyDescriptor, messageSchema);
        }
        if (protoField.isOneofPart()) {
            throw new IllegalStateException("not IMPL oneof now.");
        }
        ProtoUtils.throwNotSupportWrite(protoField, propertyDescriptor.getJavaType().getRawClass());
        return null;
    }

    protected abstract <T> FieldSchema<T> createRepeatedSchema(Field var1, PropertyDescriptor var2);
}

