/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.servo;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.SwapMeter;
import com.netflix.spectator.servo.DoubleCounter;
import com.netflix.spectator.servo.ServoClock;
import com.netflix.spectator.servo.ServoCounter;
import com.netflix.spectator.servo.ServoDistributionSummary;
import com.netflix.spectator.servo.ServoGauge;
import com.netflix.spectator.servo.ServoMaxGauge;
import com.netflix.spectator.servo.ServoMeter;
import com.netflix.spectator.servo.ServoTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ServoRegistry
extends AbstractRegistry
implements CompositeMonitor<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoRegistry.class);
    static final long EXPIRATION_TIME_MILLIS = ServoRegistry.getExpirationTimeMillis();
    private final MonitorConfig config;

    private static long getExpirationTimeMillis() {
        String key = "spectator.servo.expirationTimeInMinutes";
        long minutes = 15L;
        String v = System.getProperty("spectator.servo.expirationTimeInMinutes", "" + minutes);
        try {
            minutes = Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            LOGGER.error("invalid value for property 'spectator.servo.expirationTimeInMinutes', expecting integer: '" + v + "'. The default value of " + minutes + " minutes will be used.", (Throwable)e);
        }
        return TimeUnit.MINUTES.toMillis(minutes);
    }

    private MonitorConfig defaultConfig() {
        return new MonitorConfig.Builder("spectator.registry").withTag("id", UUID.randomUUID().toString()).build();
    }

    public ServoRegistry() {
        this(Clock.SYSTEM);
    }

    public ServoRegistry(Clock clock) {
        this(clock, null);
    }

    ServoRegistry(Clock clock, MonitorConfig config) {
        super(clock);
        this.config = config == null ? this.defaultConfig() : config;
        DefaultMonitorRegistry.getInstance().register((Monitor)this);
    }

    MonitorConfig toMonitorConfig(Id id, Tag stat) {
        MonitorConfig.Builder builder = new MonitorConfig.Builder(id.name());
        if (stat != null) {
            builder.withTag(stat.key(), stat.value());
        }
        for (Tag t : id.tags()) {
            builder.withTag(t.key(), t.value());
        }
        return builder.build();
    }

    protected Counter newCounter(Id id) {
        MonitorConfig cfg = this.toMonitorConfig(id, (Tag)Statistic.count);
        DoubleCounter counter = new DoubleCounter(cfg, new ServoClock(this.clock()));
        return new ServoCounter(id, this.clock(), counter);
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        return new ServoDistributionSummary(this, id);
    }

    protected Timer newTimer(Id id) {
        return new ServoTimer(this, id);
    }

    protected Gauge newGauge(Id id) {
        return new ServoGauge(id, this.clock(), this.toMonitorConfig(id, (Tag)Statistic.gauge));
    }

    protected Gauge newMaxGauge(Id id) {
        return new ServoMaxGauge(id, this.clock(), this.toMonitorConfig(id, (Tag)Statistic.max));
    }

    public Integer getValue() {
        return 0;
    }

    public Integer getValue(int pollerIndex) {
        return 0;
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public List<Monitor<?>> getMonitors() {
        ArrayList monitors = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Meter meter = (Meter)iterator.next();
            ServoMeter sm = this.getServoMeter(meter);
            if (meter.hasExpired() || sm == null) continue;
            sm.addMonitors(monitors);
        }
        this.removeExpiredMeters();
        return monitors;
    }

    private ServoMeter getServoMeter(Meter meter) {
        if (meter instanceof SwapMeter) {
            return this.getServoMeter(((SwapMeter)meter).get());
        }
        if (meter instanceof ServoMeter) {
            return (ServoMeter)meter;
        }
        return null;
    }
}

