/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.ProviderServerWebSocketInvocationCreator;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.common.rest.locator.ServicePathManager;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.invocation.InvocationFactory;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;

public class EdgeServerWebSocketInvocationCreator
extends ProviderServerWebSocketInvocationCreator {
    private final String microserviceName;
    protected MicroserviceReferenceConfig microserviceReferenceConfig;
    protected final String path;

    public EdgeServerWebSocketInvocationCreator(String microserviceName, String path, Endpoint endpoint, ServerWebSocket webSocket) {
        super(null, endpoint, webSocket);
        this.microserviceName = microserviceName;
        this.path = path;
    }

    @Override
    public CompletableFuture<Invocation> createAsync() {
        return this.createMicroserviceReferenceConfig().thenCompose(v -> super.createAsync());
    }

    protected CompletableFuture<Void> createMicroserviceReferenceConfig() {
        return SCBEngine.getInstance().getOrCreateReferenceConfigAsync(this.microserviceName).thenAccept(mrc -> {
            this.microserviceReferenceConfig = mrc;
            this.microserviceMeta = mrc.getMicroserviceMeta();
        });
    }

    @Override
    protected OperationLocator locateOperation(ServicePathManager servicePathManager) {
        return servicePathManager.consumerLocateOperation(this.path, HttpMethod.POST.name());
    }

    @Override
    protected Invocation createInstance() {
        ReferenceConfig referenceConfig = this.microserviceReferenceConfig.createReferenceConfig(this.restOperationMeta.getOperationMeta());
        Invocation invocation = InvocationFactory.forConsumer((ReferenceConfig)referenceConfig, (OperationMeta)this.restOperationMeta.getOperationMeta(), (InvocationRuntimeType)this.restOperationMeta.getOperationMeta().buildBaseConsumerRuntimeType(), null);
        invocation.setSync(false);
        invocation.setEdge();
        invocation.setEndpoint(this.endpoint);
        return invocation;
    }
}

