/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.transport;

import io.vertx.core.Vertx;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.SharedVertxFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public abstract class AbstractTransport
implements Transport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransport.class);
    public static final String PUBLISH_ADDRESS = "servicecomb.service.publishAddress";
    private static final String PUBLISH_PORT = "servicecomb.{transport_name}.publishPort";
    public static final String ENDPOINT_KEY = "servicecomb.endpoint";
    protected Vertx transportVertx;
    protected Endpoint endpoint;
    protected Endpoint publishEndpoint;
    protected Environment environment;

    @Override
    public Endpoint getPublishEndpoint() {
        return this.publishEndpoint;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.transportVertx = SharedVertxFactory.getSharedVertx((Environment)environment);
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema) {
        this.setListenAddressWithoutSchema(addressWithoutSchema, null);
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        addressWithoutSchema = this.genAddressWithoutSchema(addressWithoutSchema, pairs);
        this.endpoint = new Endpoint(this, NetUtils.getRealListenAddress((String)this.getName(), (String)addressWithoutSchema));
        this.publishEndpoint = this.endpoint.getEndpoint() != null ? new Endpoint(this, this.getPublishAddress(this.getName(), addressWithoutSchema)) : null;
    }

    private String genAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        if (addressWithoutSchema == null || pairs == null || pairs.isEmpty()) {
            return addressWithoutSchema;
        }
        int idx = ((String)addressWithoutSchema).indexOf(63);
        addressWithoutSchema = idx == -1 ? (String)addressWithoutSchema + "?" : (String)addressWithoutSchema + "&";
        String encodedQuery = URLEncodedUtils.format(pairs.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()), (String)StandardCharsets.UTF_8.name());
        addressWithoutSchema = (String)addressWithoutSchema + encodedQuery;
        return addressWithoutSchema;
    }

    @Override
    public Object parseAddress(String address) {
        if (address == null) {
            return null;
        }
        return new URIEndpointObject(address);
    }

    protected String getPublishAddress(String schema, String address) {
        if (address == null) {
            return address;
        }
        try {
            URI originalURI = new URI(schema + "://" + address);
            IpPort ipPort = NetUtils.parseIpPort((URI)originalURI);
            if (ipPort == null) {
                LOGGER.warn("address {} not valid.", (Object)address);
                return null;
            }
            IpPort publishIpPort = this.genPublishIpPort(schema, ipPort);
            URIBuilder builder = new URIBuilder(originalURI);
            return builder.setHost(publishIpPort.getHostOrIp()).setPort(publishIpPort.getPort()).build().toString();
        }
        catch (URISyntaxException e) {
            LOGGER.warn("address {} not valid.", (Object)address);
            return null;
        }
    }

    private IpPort genPublishIpPort(String schema, IpPort ipPort) {
        int publishPort;
        String publicAddressSetting = this.environment.getProperty(PUBLISH_ADDRESS, "");
        publicAddressSetting = publicAddressSetting.trim();
        String publishPortKey = PUBLISH_PORT.replace("{transport_name}", schema);
        int publishPortSetting = (Integer)this.environment.getProperty(publishPortKey, Integer.TYPE, (Object)0);
        int n = publishPort = publishPortSetting == 0 ? ipPort.getPort() : publishPortSetting;
        if (publicAddressSetting.isEmpty()) {
            InetSocketAddress socketAddress = ipPort.getSocketAddress();
            if (socketAddress.getAddress().isAnyLocalAddress()) {
                String host = NetUtils.getHostAddress();
                if (Inet6Address.class.isInstance(socketAddress.getAddress())) {
                    host = NetUtils.getIpv6HostAddress();
                }
                LOGGER.warn("address {}, auto select a host address to publish {}:{}, maybe not the correct one", new Object[]{socketAddress, host, publishPort});
                return new IpPort(host, publishPort);
            }
            return ipPort;
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            publicAddressSetting = NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostAddress();
        }
        return new IpPort(publicAddressSetting, publishPort);
    }
}

