/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import com.google.common.eventbus.EventBus;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.localregistry.RegistryBean;
import org.apache.servicecomb.provider.pojo.Invoker;
import org.apache.servicecomb.registry.lightweight.DiscoveryClient;
import org.apache.servicecomb.registry.lightweight.DiscoveryEndpoint;
import org.apache.servicecomb.registry.lightweight.MessageExecutor;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.StoreService;
import org.apache.servicecomb.registry.lightweight.store.Store;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class LightWeightRegistryConfiguration {
    public static final String ZERO_CONFIG_DISCOVERY_CLIENT = "zero-config-discovery-client";

    @Bean
    public Store zeroConfigStore() {
        return new Store();
    }

    @Bean
    public MessageExecutor zeroConfigMessageExecutor(Self self, StoreService storeService) {
        return new MessageExecutor(self, storeService);
    }

    @Bean
    public Self zeroConfigSelf() {
        return new Self();
    }

    @Bean
    public StoreService zeroConfigStoreService(EventBus eventBus, Store store, DiscoveryClient discoveryClient) {
        return new StoreService(eventBus, store, discoveryClient);
    }

    @Bean
    public DiscoveryEndpoint zeroConfigDiscoveryEndpoint(Self self) {
        return new DiscoveryEndpoint(self);
    }

    @Bean
    public RegistryBean zeroConfigDiscoveryServer(Environment environment) {
        return new RegistryBean().setAppId(BootStrapProperties.readApplication((Environment)environment)).setServiceName(ZERO_CONFIG_DISCOVERY_CLIENT).addSchemaInterface(ZERO_CONFIG_DISCOVERY_CLIENT, DiscoveryClient.class).setInstances(new RegistryBean.Instances().setInstances(List.of(new RegistryBean.Instance().setEndpoints(Collections.emptyList()))));
    }

    @Bean
    public DiscoveryClient zeroConfigDiscoveryClient() {
        return (DiscoveryClient)Invoker.createProxy((String)ZERO_CONFIG_DISCOVERY_CLIENT, (String)ZERO_CONFIG_DISCOVERY_CLIENT, DiscoveryClient.class);
    }
}

