/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.dynamicinclude.Configuration;
import org.apache.sling.dynamicinclude.ConfigurationWhiteboard;
import org.apache.sling.servlets.annotations.SlingServletFilter;
import org.apache.sling.servlets.annotations.SlingServletFilterScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServletFilter(scope={SlingServletFilterScope.REQUEST, SlingServletFilterScope.FORWARD})
@Component(property={"service.ranking:Integer=0"})
public class CacheControlFilter
implements Filter {
    private static final String HEADER_DATE = "Date";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final Logger LOG = LoggerFactory.getLogger(CacheControlFilter.class);
    @Reference
    private ConfigurationWhiteboard configurationWhiteboard;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String resourceType = slingRequest.getResource().getResourceType();
        Configuration config = this.configurationWhiteboard.getConfiguration(slingRequest, resourceType);
        if (config != null && config.hasTtlSet()) {
            SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
            slingResponse.setHeader(HEADER_CACHE_CONTROL, "max-age=" + config.getTtl());
            LOG.debug("set \"{}: max-age={}\" to {}", new Object[]{HEADER_CACHE_CONTROL, config.getTtl(), resourceType});
            if (!slingResponse.containsHeader(HEADER_DATE)) {
                slingResponse.setDateHeader(HEADER_DATE, System.currentTimeMillis());
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

