/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.dynamicinclude.Configuration;
import org.apache.sling.dynamicinclude.ConfigurationWhiteboard;
import org.apache.sling.servlets.annotations.SlingServletFilter;
import org.apache.sling.servlets.annotations.SlingServletFilterScope;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@SlingServletFilter(scope={SlingServletFilterScope.REQUEST})
@Component(property={"service.ranking:Integer=-2147483648", "service.vendor=The Apache Software Foundation"})
public class SyntheticResourceFilter
implements Filter {
    @Reference
    private ConfigurationWhiteboard configurationWhiteboard;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        String resourceType = SyntheticResourceFilter.getResourceTypeFromSuffix(slingRequest);
        Configuration config = this.configurationWhiteboard.getConfiguration(slingRequest, resourceType);
        if (config == null || !config.hasIncludeSelector(slingRequest) || !ResourceUtil.isSyntheticResource((Resource)slingRequest.getResource()) || config.hasExtensionSet() && !config.hasExtension(slingRequest)) {
            chain.doFilter(request, response);
            return;
        }
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType(resourceType);
        String resourcePath = StringUtils.substringBefore((String)slingRequest.getRequestPathInfo().getResourcePath(), (String)".");
        Resource resource = slingRequest.getResourceResolver().resolve(resourcePath);
        RequestDispatcher dispatcher = slingRequest.getRequestDispatcher(resource, options);
        dispatcher.forward(request, response);
    }

    private static String getResourceTypeFromSuffix(SlingHttpServletRequest request) {
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = StringUtils.substringBeforeLast((String)suffix, (String)".");
        return StringUtils.removeStart((String)suffix, (String)"/");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

