/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling Main Servlet", description="Main processor of the Sling framework controlling all aspects of processing requests inside of Sling, namely authentication, resource resolution, servlet/script resolution and execution of servlets and scripts.")
public @interface Config {
    public static final String PID = "org.apache.sling.engine.impl.SlingMainServlet";
    public static final int DEFAULT_MAX_INCLUSION_COUNTER = 50;
    public static final int DEFAULT_MAX_CALL_COUNTER = 1000;

    @AttributeDefinition(name="Number of Calls per Request", description="Defines the maximum number of Servlet and Script calls while processing a single client request. This number should be high enough to not limit request processing artificially. On the other hand it should not be too high to allow the mechanism to limit the resources required to process a request in case of errors. The default value is 1000.")
    public int sling_max_calls() default 1000;

    @AttributeDefinition(name="Recursion Depth", description="The maximum number of recursive Servlet and Script calls while processing a single client request. This number should not be too high, otherwise StackOverflowErrors may occurr in case of erroneous scripts and servlets. The default value is 50. ")
    public int sling_max_inclusions() default 50;

    @AttributeDefinition(name="Allow the HTTP TRACE method", description="If set to true, the HTTP TRACE method will be enabled. By default the HTTP TRACE methods is disabled as it can be used in Cross Site Scripting attacks on HTTP servers.")
    public boolean sling_trace_allow() default false;

    @AttributeDefinition(name="Number of Requests to Record", description="Defines the number of requests that internally recorded for display on the \"Recent Requests\" Web Console page. If this value is less than or equal to zero, no requests are internally kept. The default value is 20. ")
    public int sling_max_record_requests() default 20;

    @AttributeDefinition(name="Recorded Request Path Patterns", description="One or more regular expressions which limit the requests which are stored by the \"Recent Requests\" Web Console page.")
    public String[] sling_store_pattern_requests();

    @AttributeDefinition(name="Server Info", description="The server info returned by Sling. If this field is left empty, Sling generates a default into.")
    public String sling_serverinfo();

    @AttributeDefinition(name="Additional response headers", description="Provides mappings for additional response headers Each entry is of the form 'bundleId [ \":\" responseHeaderName ] \"=\" responseHeaderValue'")
    public String[] sling_additional_response_headers() default {"X-Content-Type-Options=nosniff", "X-Frame-Options=SAMEORIGIN"};

    @AttributeDefinition(name="Servlet Name", description="Optional name for the Sling main servlet registered by this component")
    public String servlet_name();

    @AttributeDefinition(name="Protect Headers on Includes", description="When enabled, servlets included via the RequestDispatcher will not be able to change the response status code or set headers. Any attempt to make a change is ignored. This behaviour can be overridden per include via the 'protectHeadersOnInclude' RequestDispatcherOptions key.")
    public boolean sling_includes_protectheaders() default false;

    @AttributeDefinition(name="Check Content-Type overrides", description="When enabled, it will check explicit overrides of the Content-Type header and will make the Sling Engine throw a RuntimeException when such an override is detected; otherwise the Sling Engine will only log these cases on WARN.")
    public boolean sling_includes_checkcontenttype() default false;

    @AttributeDefinition(name="Disable Spec Compliant GetUserPrincipal", description="When enabled, the getUserPrincipal method of the request object might even return a principal in the non authenticated case. This is not spec compliant but might be required for some legacy code.")
    public boolean disable_spec_compliant_getuserprincipal() default true;
}

