/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.lang.reflect.Constructor;
import org.apache.sling.models.impl.ReflectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReflectionUtilTest {
    ReflectionUtilTest() {
    }

    @Test
    void testBalancedConstructor() throws NoSuchMethodException {
        Constructor constructor = TestClassOne.class.getConstructor(Integer.TYPE, String.class);
        Assertions.assertTrue((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testMoreFieldsThanParams() throws NoSuchMethodException {
        Constructor constructor = TestClassTwo.class.getConstructor(Integer.TYPE, String.class);
        Assertions.assertFalse((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testMoreParamsThanFields() throws NoSuchMethodException {
        Constructor constructor = TestClassThree.class.getConstructor(Integer.TYPE, String.class);
        Assertions.assertFalse((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testNoFields() throws NoSuchMethodException {
        Constructor constructor = TestClassFour.class.getConstructor(Integer.TYPE, String.class, Boolean.TYPE);
        Assertions.assertFalse((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testOneFieldOneParam() throws NoSuchMethodException {
        Constructor constructor = TestClassFive.class.getConstructor(Integer.TYPE);
        Assertions.assertTrue((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testNoParams() throws NoSuchMethodException {
        Constructor constructor = TestClassSix.class.getConstructor(new Class[0]);
        Assertions.assertFalse((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testBalancedRepeatableTypes() throws NoSuchMethodException {
        Constructor constructor = TestClassSeven.class.getConstructor(String.class, String.class);
        Assertions.assertTrue((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    @Test
    void testUnbalancedRepeatableTypes() throws NoSuchMethodException {
        Constructor constructor = TestClassEight.class.getConstructor(String.class, String.class);
        Assertions.assertFalse((boolean)ReflectionUtil.areBalancedCtorParamsAndFields(constructor));
    }

    static class TestClassOne {
        private final int field1;
        private final String field2;

        public TestClassOne(int field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    static class TestClassTwo {
        private final int field1;
        private final String field2;
        private boolean field3;

        public TestClassTwo(int field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    static class TestClassThree {
        private final int field1;

        public TestClassThree(int field1, String field2) {
            this.field1 = field1;
        }
    }

    static class TestClassFour {
        public TestClassFour(int field1, String field2, boolean field3) {
        }
    }

    static class TestClassFive {
        private final int field1;

        public TestClassFive(int field1) {
            this.field1 = field1;
        }
    }

    static class TestClassSix {
        private final int field1;

        public TestClassSix() {
            this.field1 = 0;
        }
    }

    static class TestClassSeven {
        private final String field1;
        private final String field2;

        public TestClassSeven(String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
        }
    }

    static class TestClassEight {
        private final String field1;

        public TestClassEight(String field1, String field2) {
            this.field1 = field1;
        }
    }
}

