/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.ViaProviderType;
import org.apache.sling.models.impl.via.AbstractResourceTypeViaProvider;
import org.apache.sling.models.impl.via.ResourceTypeForcingJakartaRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingRequestWrapper;
import org.apache.sling.models.impl.via.ResourceTypeForcingResourceWrapper;
import org.apache.sling.models.spi.ViaProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AbstractResourceTypeViaProviderTest {
    private AbstractResourceTypeViaProvider provider = new AbstractResourceTypeViaProvider(){

        public Class<? extends ViaProviderType> getType() {
            throw new UnsupportedOperationException();
        }

        protected boolean handle(@NotNull String value) {
            return "handled".equals(value) || "nullResourceType".equals(value);
        }

        @Nullable
        protected String getResourceType(@NotNull Resource resource, @NotNull String value) {
            return "nullResourceType".equals(value) ? null : value;
        }
    };

    AbstractResourceTypeViaProviderTest() {
    }

    @Test
    void testGetAdaptableWhenNotHandled() {
        Assertions.assertEquals((Object)ViaProvider.ORIGINAL, (Object)this.provider.getAdaptable((Object)"hello", "nothandled"));
    }

    @Test
    void testGetAdaptableForResource(@Mock Resource mockResource) {
        Object adaptable = this.provider.getAdaptable((Object)mockResource, "handled");
        Assertions.assertTrue((boolean)(adaptable instanceof ResourceTypeForcingResourceWrapper));
        Assertions.assertNull((Object)this.provider.getAdaptable((Object)mockResource, "nullResourceType"));
    }

    @Test
    void testGetAdaptableForJakartaRequest(@Mock SlingJakartaHttpServletRequest mockJakartaRequest) {
        Object adaptable = this.provider.getAdaptable((Object)mockJakartaRequest, "handled");
        Assertions.assertTrue((boolean)(adaptable instanceof ResourceTypeForcingJakartaRequestWrapper));
        Assertions.assertNull((Object)this.provider.getAdaptable((Object)mockJakartaRequest, "nullResourceType"));
    }

    @Deprecated(since="2.0.0")
    @Test
    void testGetAdaptableForJavaxRequest(@Mock SlingHttpServletRequest mockJavaxRequest) {
        Object adaptable = this.provider.getAdaptable((Object)mockJavaxRequest, "handled");
        Assertions.assertTrue((boolean)(adaptable instanceof ResourceTypeForcingRequestWrapper));
        Assertions.assertNull((Object)this.provider.getAdaptable((Object)mockJavaxRequest, "nullResourceType"));
    }

    @Test
    void testGetAdaptableForOther() {
        Assertions.assertNull((Object)this.provider.getAdaptable(new Object(), "nullResourceType"));
    }
}

