/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testing.helper.FakeRequest;
import org.apache.sling.models.it.testing.helper.FakeResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class PathBoundServletIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ResourceResolverFactory rrFactory;
    private SlingRequestProcessor slingRequestProcessor;

    @Before
    public void setup() {
        this.rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.slingRequestProcessor = (SlingRequestProcessor)this.teleporter.getService(SlingRequestProcessor.class);
    }

    @Test
    public void testDoubledServlets() throws Exception {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            FakeResponse response = new FakeResponse();
            this.slingRequestProcessor.processRequest((HttpServletRequest)new FakeRequest("/apps/rtpickerrequest"), (HttpServletResponse)response, resolver);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
    }

    @Test
    public void testDoubledServletsJakarta() throws Exception {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            FakeResponse response = new FakeResponse();
            this.slingRequestProcessor.processRequest((HttpServletRequest)new FakeRequest("/apps/rtpickerrequest-jakarta"), (HttpServletResponse)response, resolver);
            Assert.assertEquals((long)200L, (long)response.getStatus());
        }
    }
}

