/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing.delegate;

import java.util.HashMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testbundle.delegate.resource.DelegateBaseModel;
import org.apache.sling.models.it.testbundle.delegate.resource.DelegateExtendedModel;
import org.apache.sling.models.it.testbundle.delegate.resource.DelegateInterface;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DelegateResourceIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ResourceResolverFactory rrFactory;
    private final String baseComponentPath = "/content/delegate/baseComponent";
    private final String extendedComponentPath = "/content/delegate/extendedComponent";

    @Before
    public void setup() throws LoginException, PersistenceException {
        this.rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        try (ResourceResolver adminResolver = this.rrFactory.getServiceResourceResolver(null);){
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("text", "baseTESTValue");
            properties.put("other", "baseOther");
            properties.put("sling:resourceType", "sling/delegate/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/delegate/baseComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("text", "extendedTESTValue");
            properties.put("other", "extendedOther");
            properties.put("sling:resourceType", "sling/delegate/extended");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/delegate/extendedComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceSuperType", "sling/delegate/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/apps/sling/delegate/extended", properties, null, (boolean)false);
            properties.clear();
            adminResolver.commit();
        }
    }

    @Test
    public void testCreateDelegateModel() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource baseComponentResource = resolver.getResource("/content/delegate/baseComponent");
            Assert.assertNotNull((Object)baseComponentResource);
            DelegateInterface modelFromBase = (DelegateInterface)baseComponentResource.adaptTo(DelegateInterface.class);
            Assert.assertNotNull((String)"Model should not be null", (Object)modelFromBase);
            Assert.assertTrue((String)"Model should be DelegateBaseModel", (boolean)(modelFromBase instanceof DelegateBaseModel));
            Assert.assertEquals((Object)"baseTESTValue", (Object)modelFromBase.getText());
            Assert.assertEquals((Object)"baseOther", (Object)modelFromBase.getOther());
            Resource extendedComponentResource = resolver.getResource("/content/delegate/extendedComponent");
            Assert.assertNotNull((Object)extendedComponentResource);
            DelegateInterface modelFromExtended = (DelegateInterface)extendedComponentResource.adaptTo(DelegateInterface.class);
            Assert.assertNotNull((String)"Model should not be null", (Object)modelFromExtended);
            Assert.assertTrue((String)"Model should be DelegateExtendedModel", (boolean)(modelFromExtended instanceof DelegateExtendedModel));
            Assert.assertEquals((Object)"EXTENDEDTESTVALUE", (Object)modelFromExtended.getText());
            Assert.assertEquals((Object)"extendedOther", (Object)modelFromExtended.getOther());
        }
    }
}

