/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.util.Collection;
import java.util.List;
import javax.script.ScriptEngine;
import javax.servlet.Servlet;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.JakartaToJavaxServletWrapper;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.core.impl.DefaultSlingScript;
import org.apache.sling.scripting.core.impl.ServiceCache;
import org.apache.sling.scripting.core.impl.SlingScriptEnginePicker;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AdapterFactory.class, MimeTypeProvider.class}, property={"service.vendor=The Apache Software Foundation", "service.description=Default SlingScriptResolver", "adaptables=org.apache.sling.api.resource.Resource", "adapters=org.apache.sling.api.scripting.SlingJakartaScript", "adapters=jakarta.servlet.Servlet", "adapters=org.apache.sling.api.scripting.SlingScript", "adapters=javax.servlet.Servlet", "adapter.condition=If the resource's path ends in an extension registered by a script engine."})
public class SlingScriptAdapterFactory
implements AdapterFactory,
MimeTypeProvider {
    private BundleContext bundleContext;
    public static final String BINDINGS_CONTEXT = "request";
    private ServiceCache serviceCache;
    @Reference
    private SlingScriptEngineManager scriptEngineManager;
    @Reference
    private volatile SlingScriptEnginePicker scriptEnginePicker;
    @Reference
    private BindingsValuesProvidersByContext bindingsValuesProviderTracker;
    @Reference
    private ScriptCache scriptCache;

    public <A> A getAdapter(@NotNull Object adaptable, @NotNull Class<A> type) {
        Resource resource = (Resource)adaptable;
        String path = resource.getPath();
        String extension = path.substring(path.lastIndexOf(46) + 1);
        List<ScriptEngine> engines = this.scriptEngineManager.getEnginesByExtension(extension);
        if (engines.isEmpty()) {
            return null;
        }
        ScriptEngine engine = engines.size() == 1 ? engines.get(0) : this.scriptEnginePicker.pickScriptEngine(engines, resource, extension);
        if (engine != null) {
            Collection bindingsValuesProviders = this.bindingsValuesProviderTracker.getBindingsValuesProviders(engine.getFactory(), BINDINGS_CONTEXT);
            DefaultSlingScript script = new DefaultSlingScript(this.bundleContext, resource, engine, bindingsValuesProviders, this.serviceCache, this.scriptCache);
            if (type == Servlet.class) {
                return (A)JakartaToJavaxServletWrapper.toJavaxServlet((jakarta.servlet.Servlet)script);
            }
            return (A)script;
        }
        return null;
    }

    public String getMimeType(String name) {
        List<String> mimeTypes;
        ScriptEngine se = this.scriptEngineManager.getEngineByExtension(name = name.substring(name.lastIndexOf(46) + 1));
        if (se != null && (mimeTypes = se.getFactory().getMimeTypes()) != null && !mimeTypes.isEmpty()) {
            return String.valueOf(mimeTypes.get(0));
        }
        return null;
    }

    public String getExtension(String mimeType) {
        List<String> extensions;
        ScriptEngine se = this.scriptEngineManager.getEngineByMimeType(mimeType);
        if (se != null && (extensions = se.getFactory().getExtensions()) != null && !extensions.isEmpty()) {
            return String.valueOf(extensions.get(0));
        }
        return null;
    }

    @Activate
    protected void activate(BundleContext bc) {
        this.bundleContext = bc;
        this.serviceCache = new ServiceCache(this.bundleContext);
    }

    @Deactivate
    protected void deactivate() {
        this.serviceCache.dispose();
        this.serviceCache = null;
        this.bundleContext = null;
    }
}

