/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.DeferredUpdateManager3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.picking.GeometryPicker;
import org.eclipse.draw3d.picking.Picker;

public class PickingUpdateManager3D
extends DeferredUpdateManager3D {
    private static final Logger log = Logger.getLogger(PickingUpdateManager3D.class.getName());
    private GeometryPicker m_picker;
    boolean pickingEnabled = true;

    public PickingUpdateManager3D(IScene i_scene) {
        if (i_scene == null) {
            throw new NullPointerException("i_scene must not be null");
        }
        this.m_picker = new GeometryPicker(i_scene);
    }

    public Picker getPicker() {
        return this.m_picker;
    }

    protected void repairDamage() {
        this.pickingEnabled = false;
        super.repairDamage();
        this.pickingEnabled = true;
    }

    public void setRoot(IFigure i_figure) {
        super.setRoot(i_figure);
        this.m_picker.setRootFigure(Figure3DHelper.getAncestor3D(i_figure));
    }
}

