/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthUtil {
    private static final String SECKEYRING_CMD = "seckeyring";
    private static final String UPDATE_OPTION = "update";
    private static final String SECTOKEN_CMD = "sectoken";
    private static final String GET_OPTION = "get";
    private static final String USERNAME_OPTION = "--username";
    private static final String PASSWORD_OPTION = "--password";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_MSG_KEY = "status_message";
    private static final String STATUS_OK_VALUE = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthToken genAuthToken(String username, String password, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AuthGenTaskLabel, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(null, new String[]{SECKEYRING_CMD, UPDATE_OPTION}, new String[]{USERNAME_OPTION, username, PASSWORD_OPTION, password, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(50));
            if (result.getExitValue() != 0) {
                Logger.logError("Seckeyring update failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Seckeyring update had 0 return code but the output is empty");
                throw new IOException("The output from seckeyring update is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!STATUS_OK_VALUE.equals(resultJson.getString(STATUS_KEY))) {
                String msg = "Seckeyring update failed for: " + conid + " with output: " + resultJson.getString(STATUS_MSG_KEY);
                Logger.logError(msg);
                throw new IOException(msg);
            }
            AuthToken authToken = AuthUtil.getAuthToken(username, conid, (IProgressMonitor)mon.split(50));
            return authToken;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthToken getAuthToken(String username, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AuthGetTaskLabel, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(new String[]{"--insecure"}, new String[]{SECTOKEN_CMD, GET_OPTION}, new String[]{USERNAME_OPTION, username, "--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon.split(100));
            if (result.getExitValue() != 0) {
                Logger.logError("Sectoken get failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Sectoken get had 0 return code but the output is empty");
                throw new IOException("The output from sectoken get is empty.");
            }
            AuthToken authToken = new AuthToken(new JSONObject(result.getOutput()));
            return authToken;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

