/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.core.internal.connection.RegistryInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementComposite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RegistryManagementDialog
extends TitleAreaDialog {
    private final CodewindConnection connection;
    private final List<RegistryInfo> regList;
    private final ImagePushRegistryInfo pushReg;
    private RegistryManagementComposite regComposite;

    public RegistryManagementDialog(Shell parentShell, CodewindConnection connection, List<RegistryInfo> regList, ImagePushRegistryInfo pushReg) {
        super(parentShell);
        this.connection = connection;
        this.regList = regList;
        this.pushReg = pushReg;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RegMgmtDialogTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.RegMgmtDialogTitle);
        if (this.connection.isLocal()) {
            this.setMessage(Messages.RegMgmtDialogLocalMessage);
        } else {
            this.setMessage(Messages.RegMgmtDialogMessage);
        }
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.regComposite = new RegistryManagementComposite(content, this.connection, this.regList, this.pushReg);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 250;
        this.regComposite.setLayoutData(data);
        return parent;
    }

    public boolean hasChanges() {
        return this.regComposite.hasChanges();
    }

    public IStatus updateRegistries(IProgressMonitor monitor) {
        return this.regComposite.updateRegistries(monitor);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(700, point.y);
    }

    public static void open(Shell shell, CodewindConnection connection, IProgressMonitor monitor) {
        try {
            List regList = connection.requestRegistryList();
            ImagePushRegistryInfo pushReg = connection.requestGetPushRegistry();
            RegistryManagementDialog regDialog = new RegistryManagementDialog(shell, connection, regList, pushReg);
            if (regDialog.open() == 0 && regDialog.hasChanges()) {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RegUpdateTask, (int)100);
                IStatus status = regDialog.updateRegistries((IProgressMonitor)mon.split(100));
                if (!status.isOK()) {
                    throw new InvocationTargetException(status.getException(), status.getMessage());
                }
                if (mon.isCanceled()) {
                    return;
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)Messages.RegListErrorTitle, (String)NLS.bind((String)Messages.RegListErrorMsg, (Object)e));
        }
    }
}

