/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.LogLevels;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class OtherUtil {
    private static final String[] LOGLEVELS_CMD = new String[]{"loglevels"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogLevels getLoglevels(String connectionName, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.FetchLogLevelsTaskLabel, (Object)connectionName), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LOGLEVELS_CMD, new String[]{"--conid", conid});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LOGLEVELS_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            LogLevels logLevels = new LogLevels(resultJson);
            return logLevels;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoglevels(String connectionName, String level, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SetLogLevelTaskLabel, (Object[])new String[]{connectionName, level}), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(CLIUtil.GLOBAL_JSON_INSECURE, LOGLEVELS_CMD, new String[]{"--conid", conid}, new String[]{level});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            CLIUtil.checkResult(LOGLEVELS_CMD, result, true);
            JSONObject resultJson = new JSONObject(result.getOutput());
            LogLevels logLevels = new LogLevels(resultJson);
            if (!logLevels.getCurrentLevel().equals(level)) {
                String msg = "The current log level is not what was requested, requested: " + level + ", actual: " + logLevels.getCurrentLevel();
                Logger.logError(msg);
                throw new IOException(msg);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

