/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class AttachDebuggerAction
extends SelectionProviderAction {
    CodewindEclipseApplication app;

    public AttachDebuggerAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.AttachDebuggerLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.projectLanguage == ProjectLanguage.LANGUAGE_NODEJS) {
                this.setText(Messages.LaunchDebugSessionLabel);
            } else {
                this.setText(Messages.AttachDebuggerLabel);
            }
            if (this.app.isAvailable() && StartMode.DEBUG_MODES.contains(this.app.getStartMode()) && this.app.getDebugPort() != -1 && (this.app.getAppStatus() == AppStatus.STARTED || this.app.getAppStatus() == AppStatus.STARTING)) {
                this.setEnabled(this.app.canAttachDebugger());
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"AttachDebuggerAction ran but no application was selected");
            return;
        }
        this.app.attachDebugger();
    }

    public boolean showAction() {
        return this.app != null && this.app.isAvailable() && this.app.supportsDebug();
    }
}

