/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.json.JSONObject;

public class HttpUtil {
    private HttpUtil() {
    }

    private static String readAllFromStream(InputStream stream) {
        Scanner s = new Scanner(stream);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    private static void logError(String str) {
        FWLogger.getInstance().logError(str);
    }

    private static void log(String str) {
        if (FWLogger.getInstance().isDebug()) {
            System.out.println(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult get(URI uri, IHttpConnectionConfig conf) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("GET");
            if (conf != null) {
                conf.setupConnection(connection);
            }
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult put(URI uri, JSONObject payload, IHttpConnectionConfig conf) throws IOException {
        HttpURLConnection connection = null;
        HttpUtil.log("PUT " + payload.toString() + " TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("PUT");
            if (conf != null) {
                conf.setupConnection(connection);
            }
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult post(URI uri, JSONObject payload, IHttpConnectionConfig conf) throws IOException {
        HttpURLConnection connection = null;
        HttpUtil.log("POST " + payload.toString() + " TO " + uri);
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("POST");
            if (conf != null) {
                conf.setupConnection(connection);
            }
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void allowAllCerts(URLConnection connection) {
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection huc = (HttpsURLConnection)connection;
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{tm}, new SecureRandom());
                huc.setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface IHttpConnectionConfig {
        public void setupConnection(URLConnection var1);
    }

    public static class HttpResult {
        public final int responseCode;
        public final boolean isGoodResponse;
        public final String response;
        public final String error;
        private final Map<String, List<String>> headerFields;

        public HttpResult(HttpURLConnection connection) throws IOException {
            this.responseCode = connection.getResponseCode();
            this.isGoodResponse = this.responseCode > 199 && this.responseCode < 300;
            this.headerFields = this.isGoodResponse ? connection.getHeaderFields() : null;
            InputStream eis = connection.getErrorStream();
            this.error = eis != null ? HttpUtil.readAllFromStream(eis) : null;
            if (!this.isGoodResponse) {
                HttpUtil.logError("Received bad response code " + this.responseCode + " from " + connection.getURL() + " - Error:\n" + this.error);
                this.response = null;
            } else {
                InputStream is = connection.getInputStream();
                this.response = is != null ? HttpUtil.readAllFromStream(is) : null;
            }
        }

        public String getHeader(String key) {
            if (this.headerFields == null) {
                return null;
            }
            List<String> list = this.headerFields.get(key);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }
}

