/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.internal.WebSocketManagerThread;

public class TyrusClientEndpoint
extends Endpoint {
    private static final FWLogger log = FWLogger.getInstance();
    private final WebSocketManagerThread parent;
    private final String wsUrl;

    public TyrusClientEndpoint(WebSocketManagerThread parent, String wsUrl) {
        this.parent = parent;
        this.wsUrl = wsUrl;
    }

    public void onOpen(Session session, EndpointConfig ec) {
        log.logInfo("WebSocket connection opened for " + this.wsUrl);
        session.addMessageHandler((MessageHandler)new StringMessageHandler(this, session));
        if (this.parent != null) {
            this.parent.setSessionFromEndpoint(session);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        log.logInfo("WebSocket connection closed with reason: " + closeReason + ", for url: " + this.wsUrl);
        if (this.parent != null) {
            this.parent.setSessionFromEndpoint(null);
            this.parent.queueEstablishConnection();
            this.parent.informConnectionFail();
        }
    }

    public void onError(Session session, Throwable thr) {
        log.logSevere("WebSocket onError throwable: " + thr + " for url: " + this.wsUrl);
    }

    private static class StringMessageHandler
    implements MessageHandler.Whole<String> {
        private static final FWLogger log = FWLogger.getInstance();
        final TyrusClientEndpoint endpoint;
        final Session session;

        public StringMessageHandler(TyrusClientEndpoint parent, Session session) {
            this.endpoint = parent;
            this.session = session;
        }

        public void onMessage(String s) {
            if (this.endpoint.parent == null) {
                return;
            }
            this.endpoint.parent.receiveMessage(s);
        }
    }
}

