/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import org.eclipse.comma.monitoring.lib.CFunctionalConstraintContext;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintResult;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintState;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public abstract class CFunctionalConstraint {
    protected String componentInstanceName;
    protected String name;
    protected CFunctionalConstraintContext portsContext;

    public CFunctionalConstraint(String name, String componentInstanceName) {
        this.name = name;
        this.componentInstanceName = componentInstanceName;
    }

    public String getName() {
        return this.name;
    }

    public void setPortsContext(CFunctionalConstraintContext context) {
        this.portsContext = context;
    }

    protected String determineContextPort(CObservedMessage msg) {
        if (this.componentInstanceName.equals(msg.getSource())) {
            return msg.getSourcePort();
        }
        if (this.componentInstanceName.equals(msg.getDestination())) {
            return msg.getDestinationPort();
        }
        return String.valueOf(msg.getDestination().substring(this.componentInstanceName.length() + 1)) + "." + msg.getDestinationPort();
    }

    protected String determineContextConnection(CObservedMessage msg) {
        if (this.componentInstanceName.equals(msg.getSource())) {
            return msg.getDestination();
        }
        if (this.componentInstanceName.equals(msg.getDestination())) {
            return msg.getSource();
        }
        return msg.getSource();
    }

    public abstract void setState(CFunctionalConstraintState var1);

    public abstract CFunctionalConstraintResult consume(CObservedMessage var1);

    public abstract CFunctionalConstraintState getInitialState();
}

