CREATE TABLE ID_GEN
  (
    ID_NAME VARCHAR(100),
    ID_VAL  INT(11)
  );

CREATE TABLE `SBI_DOMAINS` (
  `VALUE_ID` INT(11) NOT NULL,
  `VALUE_CD` VARCHAR(100) DEFAULT NULL,
  `VALUE_NM` VARCHAR(40) DEFAULT NULL,
  `DOMAIN_CD` VARCHAR(20) DEFAULT NULL,
  `DOMAIN_NM` VARCHAR(40) DEFAULT NULL,
  `VALUE_DS` VARCHAR(160) DEFAULT NULL,
  PRIMARY KEY (`VALUE_ID`)
) ;

CREATE TABLE `SBI_RESOURCES` (
  `RESOURCE_ID` int(11) NOT NULL ,
  `RESOURCE_TYPE_ID` int(11) NOT NULL,
  `TABLE_NAME` varchar(40) default NULL,
  `COLUMN_NAME` varchar(40) default NULL,
  `RESOURCE_NAME` varchar(40) NOT NULL,
  `RESOURCE_DESCR` varchar(400) default NULL,
  PRIMARY KEY  (`RESOURCE_ID`),
  UNIQUE KEY `RESOURCE_NAME` (`RESOURCE_NAME`)
);

CREATE TABLE `SBI_THRESHOLD` (
  `THRESHOLD_ID` INT(11) NOT NULL ,
  `THRESHOLD_TYPE_ID` INT(11) NOT NULL,
  `NAME` VARCHAR(400) DEFAULT NULL,
  `DESCRIPTION` VARCHAR(1000) DEFAULT NULL,
  `CODE` VARCHAR(45) DEFAULT NULL,
  PRIMARY KEY (`THRESHOLD_ID`)
) ;

CREATE TABLE `SBI_THRESHOLD_VALUE` (
  `ID_THRESHOLD_VALUE` INT(11) NOT NULL ,
  `THRESHOLD_ID` INT(11) NOT NULL,
  `SEVERITY_ID` INT(11) NOT NULL,
  `POSITION` INT(11) DEFAULT NULL,
  `MIN_VALUE` DOUBLE DEFAULT NULL,
  `MAX_VALUE` DOUBLE DEFAULT NULL,
  `LABEL` VARCHAR(20) NOT NULL,
  `COLOUR` VARCHAR(20) DEFAULT NULL,
  `MIN_CLOSED` SMALLINT(6) DEFAULT NULL,
  `MAX_CLOSED` SMALLINT(6) DEFAULT NULL,
  `TH_VALUE` DOUBLE DEFAULT NULL,
  PRIMARY KEY (`ID_THRESHOLD_VALUE`)
) ;



CREATE TABLE EBAM_EVENT (
  `EVENT_ID` double NOT NULL,
  `NAME` varchar(50) DEFAULT NULL,
  `EXPRESSION` varchar(1000) DEFAULT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `END_DATE` datetime DEFAULT NULL,
  `HANDLER_CLASS` varchar(200) DEFAULT NULL,
   PERSIST INTEGER(1) DEFAULT 1,
  PRIMARY KEY (`EVENT_ID`)
) ;


CREATE TABLE EBAM_RULES (
  `RULE_ID` int(11) NOT NULL,
  `EVENT_ID` double NOT NULL,
  `ROLE_TYPE_ID` int(11) NOT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `END_DATE` datetime DEFAULT NULL,
  `EXPRESSION` TEXT DEFAULT NULL,
  `SERVICE` varchar(100) DEFAULT NULL,
  `THRESHOLD_ID` int(11),
  PRIMARY KEY (`RULE_ID`)
) ;


CREATE TABLE SERVICE (
  `ID_SERVICE` int(10) NOT NULL ,
  `STATE` double DEFAULT NULL,
  `MONITOR_ENABLED` char(1) DEFAULT NULL,
  `STARTDATE` datetime DEFAULT NULL,
  `ENDDATE` datetime DEFAULT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`ID_SERVICE`)
);

CREATE TABLE SERVICE_INSTANCE (
  ID_SERVICE_INSTANCE DOUBLE NOT NULL ,
  ID_SERVICE INT(10)  NOT NULL,
  ID_TARGET_SERVICE_INSTANCE DOUBLE DEFAULT NULL,
  MESSAGE_ID VARCHAR(50) DEFAULT NULL,
  CORRELATION_ID VARCHAR(50) DEFAULT NULL,
  STATE DOUBLE NOT NULL DEFAULT '0',
  STARTDATE DATETIME NOT NULL,
  ENDDATE DATETIME DEFAULT NULL,
  LABEL VARCHAR(255) NOT NULL,
  MARKER CHAR(1) DEFAULT NULL,
  MONITOR_CHECK CHAR(1) DEFAULT NULL,
  ERRORS_CHECK CHAR(1) DEFAULT NULL,
  ALARMS_CHECK CHAR(1) DEFAULT NULL,
  VIEWS_CHECK CHAR(1) DEFAULT NULL,
  USER_ID VARCHAR(300) DEFAULT NULL,
  TS_UPDATE DATETIME DEFAULT NULL,
  RESOURCE_ID INT(10) DEFAULT NULL,
  PRIMARY KEY (`ID_SERVICE_INSTANCE`)
) ;

CREATE TABLE `EBAM_MESSAGE` (
  `MESSAGE_ID` int(11) NOT NULL ,
  `ID_SERVICE` int(10)  DEFAULT NULL,
  `MESSAGE_TYPE_ID` int(11) NOT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `DESCRIPTION` varchar(200) DEFAULT NULL,
  `XML_SCHEMA` varchar(1000) DEFAULT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `END_DATE` datetime DEFAULT NULL,
  `ROOT_ELEMENT` varchar(255) DEFAULT NULL,
   XSL TEXT DEFAULT NULL,
  PRIMARY KEY (`MESSAGE_ID`)
) ;

CREATE TABLE `EBAM_DATA_ATTRIBUTES` (
  `ATTRIBUTE_ID` int(11) NOT NULL ,
  `MESSAGE_ID` int(11) NOT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `ATTR_TYPE` varchar(100) DEFAULT NULL,
  `EXPRESSION` text,
  `DATA_TYPE` varchar(100) DEFAULT NULL,
  `FATHER_ID` int(10)  DEFAULT NULL,
  `LEVEL` int(10)  DEFAULT NULL,
  PRIMARY KEY (`ATTRIBUTE_ID`)
);


CREATE TABLE `EBAM_EVENT_JOURNAL` (
  `EVENT_JOURNAL_ID` double NOT NULL,
  `TIMESTAMP` datetime DEFAULT NULL,
  `EVENT_DATA` varchar(255) DEFAULT NULL,
  `EVENT_ID` double DEFAULT NULL,
  PRIMARY KEY (`EVENT_JOURNAL_ID`)
) ;



CREATE TABLE `EBAM_JOURNAL` (
  `JOURNAL_ID` double NOT NULL,
  `START_DATE` datetime DEFAULT NULL,
  `ERROR` varchar(255) DEFAULT NULL,
  `EXECUTION_TIME` datetime DEFAULT NULL,
  `XML_DATA` text,
  `PHASE_DESCR` varchar(255) DEFAULT NULL,
  `END_DATE` datetime DEFAULT NULL,
  `SERVICE_SRC_ORIG` varchar(3000) DEFAULT NULL,
  `RESPONSE` text,
  `ALARM` varchar(255) DEFAULT NULL,
  `PHASE_PROG` varchar(255) DEFAULT NULL,
  `REQUEST` text,
  `NAME` varchar(255) DEFAULT NULL,
  `STATE_DESCR` varchar(255) DEFAULT NULL,
  `TIMESTAMP_IN` datetime DEFAULT NULL,
  `PHASE_NAME` varchar(255) DEFAULT NULL,
  `WARNING` varchar(255) DEFAULT NULL,
  `MESSAGE_ID` int(11) DEFAULT NULL,
  `ID_SERVICE_INSTANCE` double DEFAULT NULL,
  `SOURCE_NAME` varchar(255) DEFAULT NULL,
  `MARKER` char(1) DEFAULT NULL,
  `LABEL` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`JOURNAL_ID`)
) ;


CREATE TABLE `EBAM_MESSAGE_CONTENT` (
  `MSG_CONTENT_ID` DOUBLE NOT NULL,
  `NAME` VARCHAR(255) DEFAULT NULL,
  `VALUE` VARCHAR(255) DEFAULT NULL,
  `ATTRIBUTE_ID` INT(11) NOT NULL,
  `JOURNAL_ID` DOUBLE NOT NULL,
  `FATHER_ID` DOUBLE DEFAULT NULL,
  `DETAIL_LIST` TEXT,
  `DETAIL_XML` TEXT,
  `LEVEL` INT(10)  DEFAULT NULL,
  PRIMARY KEY (`MSG_CONTENT_ID`)
) ;


CREATE TABLE `SBI_ALARM` (
  `ALARM_ID` INT(11) NOT NULL ,
  `LABEL` VARCHAR(50) DEFAULT NULL,
  `NAME` VARCHAR(50) DEFAULT NULL,
  `DESCR` VARCHAR(200) DEFAULT NULL,
  `TEXT` VARCHAR(1000) DEFAULT NULL,
  `URL` VARCHAR(20) DEFAULT NULL,
  `SINGLE_EVENT` CHAR(1) DEFAULT NULL,
  `AUTO_DISABLED` CHAR(1) DEFAULT NULL,
  `ID_THRESHOLD_VALUE` INT(11) DEFAULT NULL,
  `MODALITY_ID` INT(11) DEFAULT NULL,
  `DOCUMENT_ID` INT(11) DEFAULT NULL,
  `EVENT_ID` double,
  PRIMARY KEY (`ALARM_ID`)
) ;

CREATE TABLE `SBI_ALARM_CONTACT` (
  `ALARM_CONTACT_ID` INT(11) NOT NULL ,
  `NAME` VARCHAR(100) DEFAULT NULL,
  `EMAIL` VARCHAR(100) DEFAULT NULL,
  `MOBILE` VARCHAR(50) NOT NULL,
  `RESOURCES` VARCHAR(200) DEFAULT NULL,
  PRIMARY KEY (`ALARM_CONTACT_ID`)
) ;

CREATE TABLE `SBI_ALARM_DISTRIBUTION` (
  `ALARM_ID` INT(11) NOT NULL,
  `ALARM_CONTACT_ID` INT(11) NOT NULL,
  PRIMARY KEY (`ALARM_ID`,`ALARM_CONTACT_ID`)
) ;

CREATE TABLE `SBI_ALARM_EVENT` (
  `ALARM_EVENT_ID` INT(11) NOT NULL ,
  `EVENT_TS` DATETIME DEFAULT NULL,
  `RESOURCES` VARCHAR(255) DEFAULT NULL,
  `RESOURCE_ID` INT(11) DEFAULT NULL,
  `THRESHOLD_VALUE` VARCHAR(255) DEFAULT NULL,
  `KPI_NAME` VARCHAR(255) DEFAULT NULL,
  `ACTIVE` VARCHAR(255) DEFAULT NULL,
  `KPI_DESCRIPTION` VARCHAR(255) DEFAULT NULL,
  `KPI_INSTANCE_ID` INT(11) DEFAULT NULL,
  `KPI_VALUE` VARCHAR(255) DEFAULT NULL,
  `ALARM_ID` INT(11) DEFAULT NULL,
  PRIMARY KEY (`ALARM_EVENT_ID`)
) ;

CREATE TABLE EBAM_MESSAGE_ENGINE (
      MESSAGE_ID INTEGER(10) NOT NULL,
      VALUE_ID INTEGER(10) NOT NULL,
      PRIMARY KEY (MESSAGE_ID, VALUE_ID)
);


CREATE TABLE EBAM_EVENT_ATTRIBUTES (
      EVENT_ATTR_ID INTEGER(10) NOT NULL,
      EVENT_ID DOUBLE,
      NAME VARCHAR(50),
      EXPRESSION VARCHAR(100),
      PRIMARY KEY (EVENT_ATTR_ID)

);


CREATE TABLE EBAM_EVENT_CONTENTS (
      EVENT_CONTENT_ID INTEGER(10) NOT NULL,
      EVENT_JOURNAL_ID DOUBLE NOT NULL,
      EVENT_ATTR_ID  INTEGER(10) NOT NULL,
      NAME VARCHAR(100),
      VALUE VARCHAR(100)
);

