/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.DefaultMailbox;
import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.Mailbox;
import com.sun.mail.mbox.MboxFolder;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class MboxStore
extends Store {
    String user = System.getProperty("user.name");
    String home = System.getProperty("user.home");
    Mailbox mb;
    static Flags permFlags = new Flags();

    static {
        permFlags.add(Flags.Flag.SEEN);
        permFlags.add(Flags.Flag.RECENT);
        permFlags.add(Flags.Flag.DELETED);
        permFlags.add(Flags.Flag.FLAGGED);
        permFlags.add(Flags.Flag.ANSWERED);
        permFlags.add(Flags.Flag.DRAFT);
        permFlags.add(Flags.Flag.USER);
    }

    public MboxStore(Session session, URLName url) {
        super(session, url);
        String os = System.getProperty("os.name");
        try {
            String cl = "com.sun.mail.mbox." + os + "Mailbox";
            this.mb = (Mailbox)Class.forName(cl).newInstance();
        }
        catch (Exception exception) {
            this.mb = new DefaultMailbox();
        }
    }

    @Override
    protected boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        return true;
    }

    @Override
    protected void setURLName(URLName url) {
        if (url != null && (url.getUsername() != null || url.getHost() != null || url.getFile() != null)) {
            url = new URLName(url.getProtocol(), null, -1, null, null, null);
        }
        super.setURLName(url);
    }

    @Override
    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new MboxFolder(this, null);
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new MboxFolder(this, name);
    }

    @Override
    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    private void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }

    MailFile getMailFile(String folder) {
        return this.mb.getMailFile(this.user, folder);
    }

    Session getSession() {
        return this.session;
    }
}

