/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.ebpm.startup.service.IStartedUpService;
import org.eclipse.ebpm.startup.service.SpagicStartedUpService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ScrappyActivator
implements BundleActivator {
    public void stop(BundleContext context) throws Exception {
    }

    protected void ebpmBanner(BundleContext context) {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(context.getBundle().getEntry("/baseconf/ebpm_banner.txt").openStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    protected void createFileFromBundleEntryIfNotExist(String filePath, String relativeBundleEntry, BundleContext context) {
        File destFile = new File(filePath);
        if (!destFile.exists()) {
            InputStream in = null;
            OutputStream out = null;
            try {
                try {
                    destFile.createNewFile();
                    Bundle contextBundle = context.getBundle();
                    URL url = contextBundle.getEntry(relativeBundleEntry);
                    in = url.openStream();
                    out = new FileOutputStream(destFile);
                    this.copy(in, out);
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        in.close();
                        out.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    in.close();
                    out.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    protected String getDefaultNodeId() {
        return "node1";
    }

    protected void createSpagicXML(String filePath, BundleContext context) {
        File destFile = new File(filePath);
        if (!destFile.exists()) {
            XMLWriter w = null;
            FileWriter fw = null;
            try {
                try {
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    fw = new FileWriter(destFile);
                    w = new XMLWriter((Writer)fw, format);
                    Document document = DocumentHelper.createDocument();
                    Element root = document.addElement("spagic");
                    root.addAttribute("nodeid", this.getDefaultNodeId());
                    root.addAttribute("nodetype", "master");
                    root.addAttribute("distributed", "false");
                    root.addAttribute("hostName", "localhost");
                    root.addAttribute("adminPort", "9090");
                    Element admin_services = root.addElement("admin_services");
                    admin_services.addElement("client_proxy").addAttribute("ssl", "false").addAttribute("ctx", "/client_remote");
                    admin_services.addElement("deploy_resources").addAttribute("ssl", "false").addAttribute("ctx", "/deployResources");
                    admin_services.addElement("get_resources").addAttribute("ssl", "false").addAttribute("ctx", "/getResources");
                    admin_services.addElement("services_status").addAttribute("ssl", "false").addAttribute("ctx", "/SpagicQueryService");
                    admin_services.addElement("services_toggle").addAttribute("ssl", "false").addAttribute("ctx", "/SpagicToggleService");
                    admin_services.addElement("shutdown").addAttribute("ssl", "false").addAttribute("ctx", "/shutdown");
                    admin_services.addElement("wfengine").addAttribute("ssl", "false").addAttribute("ctx", "/wfengine");
                    Element ssl = root.addElement("ssl");
                    ssl.addComment("Values Possible for clientAuthentication field");
                    ssl.addComment("1) NoClientAuthentication");
                    ssl.addComment("2) OptionalClientAuthentication");
                    ssl.addComment("3) MandatoryClientAuthentication");
                    ssl.addAttribute("clientAuthentication", "NoClientAuthentication");
                    ssl.addAttribute("port", "9443");
                    ssl.addAttribute("keystore", "keystore://keystore.jks");
                    ssl.addAttribute("keystoreType", "JKS");
                    ssl.addAttribute("keystorePassword", "changeit");
                    ssl.addAttribute("truststore", "keystore://truststore.jks");
                    ssl.addAttribute("truststoreType", "JKS");
                    ssl.addAttribute("truststorePassword", "changeit");
                    Element cluster = root.addElement("cluster");
                    cluster.addAttribute("clusterid", "SpagicCluster");
                    cluster.addAttribute("masterslave", "false");
                    cluster.addAttribute("referredmaster", "mymaster");
                    cluster.addAttribute("distributedtopic", "tcp://localhost:61616/exampleTopic");
                    w.write(document);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (w != null) {
                            w.close();
                        } else if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (w != null) {
                        w.close();
                    } else if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void readNodeProperties(String spagicXML) {
        try {
            System.out.println("Scrappy Startup --> Reading Node Properties");
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new File(spagicXML));
            Element spagicElement = doc.getRootElement();
            String nodeId = spagicElement.attributeValue("nodeid");
            String nodeType = spagicElement.attributeValue("nodetype");
            String nodeHostName = spagicElement.attributeValue("hostName");
            String nodeAdminPort = spagicElement.attributeValue("adminPort");
            String isDistributed = spagicElement.attributeValue("distributed");
            Element clusterElement = spagicElement.element("cluster");
            String clusterId = clusterElement.attributeValue("clusterid");
            String isMasterSlaveEnabled = clusterElement.attributeValue("masterslave");
            String referredMaster = clusterElement.attributeValue("referredmaster");
            System.out.println("Scrappy Startup --> Reading Node Properties NodeId[" + nodeId + "]");
            System.out.println("Scrappy Startup --> Reading Node Properties NodeId[" + nodeType + "]");
            System.out.println("Scrappy Startup --> Reading Node Properties isDistributed[" + isDistributed + "]");
            System.out.println("Scrappy Startup --> Reading Node Properties clusterId[" + clusterId + "]");
            System.out.println("Scrappy Startup --> Reading Node Properties isMasterSlaveEnabled[" + isMasterSlaveEnabled + "]");
            System.out.println("Scrappy Startup --> Reading Node Properties referredMaster[" + referredMaster + "]");
            String distributedEventAdmintopicUrl = clusterElement.attributeValue("distributedtopic");
            System.setProperty("SPAGIC_NODE_IDENTIFIER", nodeId);
            System.setProperty("SPAGIC_NODE_TYPE", nodeType);
            System.setProperty("SPAGIC_NODE_HOST_NAME", nodeHostName);
            System.setProperty("SPAGIC_NODE_ADMIN_PORT", nodeAdminPort);
            System.setProperty("DISTRIBUTED_EVENT_ADMIN_TOPIC_URL", distributedEventAdmintopicUrl);
            System.setProperty("clusterId", clusterId);
            System.setProperty("isClustered", isDistributed);
            System.setProperty("isMasterSlave", isMasterSlaveEnabled);
            System.setProperty("masterId", referredMaster);
            System.setProperty("SPAGIC_NODE_SSL_PORT", spagicElement.element("ssl").attributeValue("port"));
            System.setProperty("node_ssl_config", spagicElement.element("ssl").asXML());
            System.setProperty("node_admin_services_config", spagicElement.element("admin_services").asXML());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void nodeBootstrap(String home, BundleContext context) throws Exception {
        this.checkOrCreateFolder(home);
        String logBackFileLocation = System.getProperty("logback.configurationFile");
        if (logBackFileLocation == null) {
            logBackFileLocation = String.valueOf(home) + File.separator + "logback.xml";
            System.setProperty("logback.configurationFile", logBackFileLocation);
        }
        this.createFileFromBundleEntryIfNotExist(logBackFileLocation, "/baseconf/logback.xml", context);
        String defaultProfileServiceFileLocation = String.valueOf(home) + File.separator + "userprofile.xml";
        this.createFileFromBundleEntryIfNotExist(defaultProfileServiceFileLocation, "/baseconf/userprofile.xml", context);
        String spagicXMLFileLocation = String.valueOf(home) + File.separator + "spagic.xml";
        this.createSpagicXML(spagicXMLFileLocation, context);
        String deployFileLocation = String.valueOf(home) + File.separator + "deploy.properties";
        this.createFileFromBundleEntryIfNotExist(deployFileLocation, "/baseconf/deploy.properties", context);
        String applicationFileLocation = String.valueOf(home) + File.separator + "spagic-applications.xml";
        this.createFileFromBundleEntryIfNotExist(applicationFileLocation, "/baseconf/spagic-applications.xml", context);
        this.readNodeProperties(spagicXMLFileLocation);
    }

    protected void scrappyHomeBootstrap(String home, BundleContext context) throws Exception {
        String servicesFolder = String.valueOf(home) + File.separator + "services";
        System.out.println("Scrappy Startup --> SERVICE FOLDER [" + servicesFolder + "]");
        this.checkOrCreateFolder(servicesFolder);
        String connectorFolder = String.valueOf(home) + File.separator + "connectors";
        System.out.println("Scrappy Startup --> CONNECTOR FOLDER [" + connectorFolder + "]");
        this.checkOrCreateFolder(connectorFolder);
        String datasourcesFolder = String.valueOf(home) + File.separator + "datasources";
        System.out.println("Scrappy Startup --> DATASOURCE FOLDER [" + datasourcesFolder + "]");
        this.checkOrCreateFolder(datasourcesFolder);
        String connectionFactoriesFolder = String.valueOf(home) + File.separator + "connectionfactories";
        System.out.println("Scrappy Startup --> CONNECTION FACTORIES FOLDER [" + connectionFactoriesFolder + "]");
        this.checkOrCreateFolder(connectionFactoriesFolder);
        String processesFolder = String.valueOf(home) + File.separator + "processes";
        System.out.println("Scrappy Startup --> PROCESSES FOLDER [" + processesFolder + "]");
        this.checkOrCreateFolder(processesFolder);
        String bpmnFolder = String.valueOf(processesFolder) + File.separator + "bpmn";
        System.out.println("Scrappy Startup --> BPMN FOLDER [" + bpmnFolder + "]");
        this.checkOrCreateFolder(bpmnFolder);
        String graphFolder = String.valueOf(processesFolder) + File.separator + "graph";
        System.out.println("Scrappy Startup --> GRAPH FOLDER [" + graphFolder + "]");
        this.checkOrCreateFolder(graphFolder);
        String imFolder = String.valueOf(processesFolder) + File.separator + "im";
        System.out.println("Scrappy Startup --> IM FOLDER [" + imFolder + "]");
        this.checkOrCreateFolder(imFolder);
        String jpdlFolder = String.valueOf(processesFolder) + File.separator + "jpdl";
        System.out.println("Scrappy Startup --> JPDL FOLDER [" + jpdlFolder + "]");
        this.checkOrCreateFolder(jpdlFolder);
        String resourceFolder = String.valueOf(home) + File.separator + "resources";
        System.out.println("Scrappy Startup --> RESOURCE FOLDER [" + resourceFolder + "]");
        this.checkOrCreateFolder(resourceFolder);
        String scriptFolder = String.valueOf(resourceFolder) + File.separator + "script";
        System.out.println("Scrappy Startup --> SCRIPT FOLDER [" + scriptFolder + "]");
        this.checkOrCreateFolder(scriptFolder);
        String wsdlFolder = String.valueOf(resourceFolder) + File.separator + "wsdl";
        System.out.println("Scrappy Startup --> WSDL FOLDER [" + wsdlFolder + "]");
        this.checkOrCreateFolder(wsdlFolder);
        String xsdFolder = String.valueOf(resourceFolder) + File.separator + "xsd";
        System.out.println("Scrappy Startup --> XSD FOLDER [" + xsdFolder + "]");
        this.checkOrCreateFolder(xsdFolder);
        String xslFolder = String.valueOf(resourceFolder) + File.separator + "xsl";
        System.out.println("Scrappy Startup --> XSL FOLDER [" + xslFolder + "]");
        this.checkOrCreateFolder(xslFolder);
        String schematronFolder = String.valueOf(resourceFolder) + File.separator + "schematron";
        System.out.println("Scrappy Startup --> SCHEMATRON FOLDER [" + schematronFolder + "]");
        this.checkOrCreateFolder(schematronFolder);
        String keystoresFolder = String.valueOf(resourceFolder) + File.separator + "keystore";
        System.out.println("Scrappy Startup --> KEYSTORES FOLDER [" + keystoresFolder + "]");
        this.checkOrCreateFolder(keystoresFolder);
        String pdfFolder = String.valueOf(resourceFolder) + File.separator + "pdf";
        System.out.println("Scrappy Startup --> PDF FOLDER [" + pdfFolder + "]");
        this.checkOrCreateFolder(pdfFolder);
        String propertiesFolder = String.valueOf(resourceFolder) + File.separator + "properties";
        System.out.println("Scrappy Startup --> SCRIPT FOLDER [" + propertiesFolder + "]");
        this.checkOrCreateFolder(propertiesFolder);
        String routesFolder = String.valueOf(home) + File.separator + "routes";
        System.out.println("Scrappy Startup --> ROUTES FOLDER [" + routesFolder + "]");
        this.checkOrCreateFolder(routesFolder);
        String baseDatasourcesFolder = "baseconf/datasources";
        String baseServicesFolder = "baseconf/services";
        String baseConnectorsFolder = "baseconf/connectors";
        String baseConnectionFactoriesFolder = "baseconf/connectionfactories";
        String baseResourcesFolder = "baseconf/resources";
        String baseScriptFolder = String.valueOf(baseResourcesFolder) + "/script";
        String baseWsdlFolder = String.valueOf(baseResourcesFolder) + "/wsdl";
        String baseXsdFolder = String.valueOf(baseResourcesFolder) + "/xsd";
        String baseXslFolder = String.valueOf(baseResourcesFolder) + "/xsl";
        String basePropertiesFolder = String.valueOf(baseResourcesFolder) + "/properties";
        String baseKeystoresFolder = String.valueOf(baseResourcesFolder) + "/keystore";
        String basePdfFolder = String.valueOf(baseResourcesFolder) + "/pdf";
        String baseSchematronFolder = String.valueOf(baseResourcesFolder) + "/schematron";
        this.retrieveFilesFromBundleEntryAnd(datasourcesFolder, baseDatasourcesFolder, context);
        this.retrieveFilesFromBundleEntryAnd(servicesFolder, baseServicesFolder, context);
        this.retrieveFilesFromBundleEntryAnd(connectorFolder, baseConnectorsFolder, context);
        this.retrieveFilesFromBundleEntryAnd(connectionFactoriesFolder, baseConnectionFactoriesFolder, context);
        this.retrieveFilesFromBundleEntryAnd(scriptFolder, baseScriptFolder, context);
        this.retrieveFilesFromBundleEntryAnd(wsdlFolder, baseWsdlFolder, context);
        this.retrieveFilesFromBundleEntryAnd(xsdFolder, baseXsdFolder, context);
        this.retrieveFilesFromBundleEntryAnd(xslFolder, baseXslFolder, context);
        this.retrieveFilesFromBundleEntryAnd(propertiesFolder, basePropertiesFolder, context);
        this.retrieveFilesFromBundleEntryAnd(keystoresFolder, baseKeystoresFolder, context);
        this.retrieveFilesFromBundleEntryAnd(pdfFolder, basePdfFolder, context);
        this.retrieveFilesFromBundleEntryAnd(schematronFolder, baseSchematronFolder, context);
    }

    public void start(BundleContext context) throws Exception {
        this.ebpmBanner(context);
        this.debugSystemProperties();
        String home = System.getProperty("spagic.home");
        if (home == null) {
            home = System.getProperty("user.dir");
            home = String.valueOf(home) + File.separator + "default";
            System.out.println("Scrappy Startup --> SPAGIC_HOME NOT SET USE THE CURRENT FOLDER [" + home + "]");
            System.setProperty("spagic.home", home);
        }
        this.nodeBootstrap(home, context);
        this.scrappyHomeBootstrap(home, context);
        String spagicMode = System.getProperty("spagic.mode");
        if (spagicMode != null && spagicMode.equalsIgnoreCase("configuration")) {
            System.out.println("Spagic run in configuration mode [" + home + "] end correctly use the osgi console to close it ");
        } else {
            context.registerService(IStartedUpService.class.getName(), (Object)new SpagicStartedUpService(), null);
        }
    }

    private void checkOrCreateFolder(String fName) throws Exception {
        File f = new File(String.valueOf(fName) + File.separator);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void debugSystemProperties() {
        System.out.println("[=========================================================================]");
        System.out.println("[                      ENVIRONMENT INFO                                  =]");
        System.out.println("[=========================================================================]");
        Set<String> sysPropertiesNames = System.getProperties().stringPropertyNames();
        ArrayList<String> pNames = new ArrayList<String>();
        pNames.addAll(sysPropertiesNames);
        Collections.sort(pNames);
        for (String name : pNames) {
            System.out.println("[" + name + "] -> [" + System.getProperty(name) + "]");
        }
    }

    void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private void retrieveFilesFromBundleEntryAnd(String folderPath, String relativeFolderPath, BundleContext context) {
        Enumeration enm = context.getBundle().getEntryPaths(relativeFolderPath);
        if (enm != null) {
            while (enm.hasMoreElements()) {
                String elem = (String)enm.nextElement();
                String s = elem.substring(relativeFolderPath.length());
                if (s.equalsIgnoreCase("/.svn/") || s.equalsIgnoreCase(".svn")) continue;
                this.createFileFromBundleEntryIfNotExist(String.valueOf(folderPath) + s, String.valueOf(relativeFolderPath) + s, context);
            }
        }
    }
}

