/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ebpm.connectors.ftp.FTPClientPool;
import org.eclipse.ebpm.connectors.ftp.FtpParameters;
import org.eclipse.ebpm.connectors.ftp.IFtpReader;
import org.eclipse.ebpm.connectors.ftp.PollingTask;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FtpReaderComponent
extends BaseSpagicService
implements IFtpReader {
    protected Logger log = LoggerFactory.getLogger(FtpReaderComponent.class);
    public static final String PROPERTY_USER_XPATH = "userXPath";
    public static final String PROPERTY_PASSWORD_XPATH = "passwordXPath";
    public static final String PROPERTY_HOST_XPATH = "hostXPath";
    public static final String PROPERTY_PORT_XPATH = "portXPath";
    public static final String PROPERTY_FILE_FILTER_XPATH = "fileFilterXPath";
    private static ThreadLocal<Exchange> exchanges = new ThreadLocal();
    private static ThreadLocal<Message> outMessages = new ThreadLocal();
    private FtpParameters ftpParams;
    private ConcurrentHashMap<String, FileMarshaler> marshalers = new ConcurrentHashMap();
    private String marshalerId;
    private FileFilter filter;
    private String userXPath;
    private String passwordXPath;
    private String hostXPath;
    private String portXPath;
    private String fileFilterXPath;

    public void init() {
        this.ftpParams = new FtpParameters();
        FTPClientPool clientPool = null;
        this.marshalerId = this.propertyConfigurator.getString("marshaler", null);
        try {
            clientPool = this.createClientPool();
            clientPool.setBinaryMode(this.propertyConfigurator.getBoolean("binaryMode", Boolean.valueOf(true)));
            clientPool.setUsername(this.propertyConfigurator.getString("username", null));
            clientPool.setPassword(this.propertyConfigurator.getString("password", null));
            if (this.propertyConfigurator.getBoolean("passiveMode", null) != null) {
                clientPool.setPassiveMode(this.propertyConfigurator.getBoolean("passiveMode"));
            }
            clientPool.setHost(this.propertyConfigurator.getString("host"));
            clientPool.setPort(this.propertyConfigurator.getInteger("port", Integer.valueOf(21)));
            this.setClientPool(clientPool);
            this.userXPath = this.propertyConfigurator.getString(PROPERTY_USER_XPATH, null);
            this.passwordXPath = this.propertyConfigurator.getString(PROPERTY_PASSWORD_XPATH, null);
            this.hostXPath = this.propertyConfigurator.getString(PROPERTY_HOST_XPATH, null);
            this.portXPath = this.propertyConfigurator.getString(PROPERTY_PORT_XPATH, null);
            this.fileFilterXPath = this.propertyConfigurator.getString(PROPERTY_FILE_FILTER_XPATH, null);
        }
        catch (Exception e) {
            this.log.error("Error creating FTPClientPool", (Throwable)e);
        }
        this.setDeleteFile(this.propertyConfigurator.getBoolean("deleteFile", Boolean.valueOf(true)));
        this.setRecursive(this.propertyConfigurator.getBoolean("recursive", Boolean.valueOf(true)));
        this.setChangeWorkingDirectory(this.propertyConfigurator.getBoolean("changeWorkingDirectory"));
        try {
            URI uri = this.createUri(clientPool, this.propertyConfigurator.getString("folder", ""));
            this.setUri(uri);
        }
        catch (URISyntaxException e) {
            this.log.error("Error creating URI", (Throwable)e);
        }
        this.setStateless(this.propertyConfigurator.getBoolean("stateless", Boolean.valueOf(true)));
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshalers.put(marshaler.getMarshalerId(), marshaler);
    }

    public void unsetMarshaler(FileMarshaler marshaler) {
        this.marshalers.remove(marshaler.getMarshalerId());
    }

    private URI createUri(FTPClientPool clientPool, String folder) throws URISyntaxException {
        if (clientPool.getUsername().equalsIgnoreCase("anonymous")) {
            clientPool.setPassword("anonymous@anonymous.com");
        }
        String ftpUri = "ftp://" + clientPool.getUsername() + (clientPool.getPassword() != null ? ":" + clientPool.getPassword() : "") + "@" + clientPool.getHost() + ":" + clientPool.getPort() + "/" + folder;
        URI uri = new URI(ftpUri);
        return uri;
    }

    @Override
    public FTPClientPool getClientPool() {
        return this.ftpParams.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.ftpParams.clientPool = clientPool;
    }

    public URI getUri() {
        return this.ftpParams.uri;
    }

    public void setUri(URI uri) {
        this.ftpParams.uri = uri;
    }

    @Override
    public String getWorkingPath() {
        return this.ftpParams.uri != null && this.ftpParams.uri.getPath() != null ? this.ftpParams.uri.getPath() : ".";
    }

    @Override
    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isDeleteFile() {
        return this.ftpParams.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.ftpParams.deleteFile = deleteFile;
    }

    @Override
    public boolean isRecursive() {
        return this.ftpParams.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.ftpParams.recursive = recursive;
    }

    @Override
    public FileMarshaler getMarshaler() {
        if (!this.marshalers.containsKey("DEFAULT")) {
            this.log.error("Default Marshaler not found");
            return null;
        }
        if (this.marshalerId == null) {
            this.log.info("Using Default Marshaler");
            return this.marshalers.get("DEFAULT");
        }
        if (!this.marshalers.containsKey(this.marshalerId)) {
            this.log.info("Marshaler with id \"" + this.marshalerId + "\" not found. Using Default Marshaler");
            return this.marshalers.get("DEFAULT");
        }
        return this.marshalers.get(this.marshalerId);
    }

    public void setChangeWorkingDirectory(boolean changeWorkingDirectory) {
        this.ftpParams.changeWorkingDirectory = changeWorkingDirectory;
    }

    @Override
    public boolean isChangeWorkingDirectory() {
        return this.ftpParams.changeWorkingDirectory;
    }

    @Override
    public boolean isStateless() {
        return this.ftpParams.stateless;
    }

    public void setStateless(boolean stateless) {
        this.ftpParams.stateless = stateless;
    }

    public String getLocationURI() {
        return this.getUri().toString();
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    public Exchange getExchange() {
        return this.createInOnlyExchange();
    }

    @Override
    public void sendFtpExchange(Exchange exchange) {
        this.log.debug("Sending message ");
    }

    @Override
    public Exchange getFtpExchange() {
        Exchange result = exchanges.get();
        if (result != null) {
            exchanges.remove();
        } else {
            this.log.error("Unexpected call to getFtpExchange");
        }
        return result;
    }

    @Override
    public Message getMessage(Exchange exchange) {
        Message result = outMessages.get();
        if (result != null) {
            outMessages.remove();
        } else {
            this.log.error("Unexpected call to getMessage");
        }
        return result;
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        String port;
        String fileFilter = null;
        SourceTransformer st = new SourceTransformer();
        Document msgBody = st.toDOMDocument(in);
        EXMLUtils xmlUtils = new EXMLUtils(DOM4JUtils.getNamespaceContext((Document)msgBody));
        if (this.userXPath != null) {
            this.getClientPool().setUsername(xmlUtils.valueOf((Node)msgBody, this.userXPath));
        }
        if (this.passwordXPath != null) {
            this.getClientPool().setPassword(xmlUtils.valueOf((Node)msgBody, this.passwordXPath));
        }
        if (this.hostXPath != null) {
            this.getClientPool().setHost(xmlUtils.valueOf((Node)msgBody, this.hostXPath));
        }
        if (this.portXPath != null && (port = xmlUtils.valueOf((Node)msgBody, this.portXPath)) != null) {
            try {
                int portInt = Integer.valueOf(port);
                this.getClientPool().setPort(portInt);
            }
            catch (NumberFormatException nfe) {
                this.log.error("Error retrieving port from XPath expression: " + this.portXPath, (Throwable)nfe);
            }
        }
        if (this.fileFilterXPath != null) {
            fileFilter = xmlUtils.valueOf((Node)msgBody, this.fileFilterXPath);
            this.setFilter(new EqualityFilter(fileFilter));
        }
        exchanges.set(exchange);
        outMessages.set(out);
        PollingTask pt = new PollingTask(this, this.target);
        pt.run();
        if (!pt.isMessageSent()) {
            this.fail(exchange, new RuntimeException("<ERROR>File " + (fileFilter != null ? fileFilter : "") + " not found</ERROR>"));
            return false;
        }
        return true;
    }

    public Exchange createExchange() {
        return this.createInOnlyExchange();
    }

    public class EqualityFilter
    implements FileFilter {
        private String fileName;

        public EqualityFilter(String fileName) {
            if (fileName.startsWith("\\\\")) {
                fileName = "\\" + fileName.substring(2);
            }
            this.fileName = fileName;
        }

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getPath();
            path = path.replace('/', '\\');
            this.fileName = this.fileName.replace('/', '\\');
            if (path.startsWith("\\\\")) {
                path = "\\" + path.substring(2);
            }
            FtpReaderComponent.this.log.debug("path:" + path + ",fileName:" + this.fileName);
            return this.fileName.equals(path) || this.fileName.contains(path) || path.contains(this.fileName);
        }
    }
}

